/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.repair;

import co.codewizards.cloudstore.core.config.Config;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.ISO8601;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairDeleteCollisionConfig {
    private static final Logger logger = LoggerFactory.getLogger(RepairDeleteCollisionConfig.class);
    public static final String CONFIG_KEY_DELETE_COLLISIONS_FROM = "repair.deleteCollisions.from";
    public static final String CONFIG_KEY_DELETE_COLLISIONS_TO = "repair.deleteCollisions.to";
    protected final File localRoot;

    protected RepairDeleteCollisionConfig(File localRoot) {
        this.localRoot = (File)AssertUtil.assertNotNull((Object)localRoot, (String)"localRoot");
    }

    public static RepairDeleteCollisionConfig getInstance(File localRoot) {
        return new RepairDeleteCollisionConfig((File)AssertUtil.assertNotNull((Object)localRoot, (String)"localRoot"));
    }

    public Date getDeleteCollisionsFrom() {
        Config config = ConfigImpl.getInstanceForDirectory((File)this.localRoot);
        String configKey = CONFIG_KEY_DELETE_COLLISIONS_FROM;
        Date result = config.getPropertyAsDate(CONFIG_KEY_DELETE_COLLISIONS_FROM, null);
        logger.info("getDeleteCollisionsFrom: localRoot='{}' configKey='{}' result={}", new Object[]{this.localRoot, CONFIG_KEY_DELETE_COLLISIONS_FROM, result == null ? null : ISO8601.formatDate((Date)result)});
        return result;
    }

    public Date getDeleteCollisionsTo() {
        Config config = ConfigImpl.getInstanceForDirectory((File)this.localRoot);
        String configKey = CONFIG_KEY_DELETE_COLLISIONS_TO;
        Date result = config.getPropertyAsDate(CONFIG_KEY_DELETE_COLLISIONS_TO, null);
        logger.info("getDeleteCollisionsTo: localRoot='{}' configKey='{}' result={}", new Object[]{this.localRoot, CONFIG_KEY_DELETE_COLLISIONS_TO, result == null ? null : ISO8601.formatDate((Date)result)});
        return result;
    }

    public boolean isCreateCollisionSuppressed() {
        Date deleteCollisionsFrom = this.getDeleteCollisionsFrom();
        Date deleteCollisionsTo = this.getDeleteCollisionsTo();
        if (deleteCollisionsFrom == null && deleteCollisionsTo == null) {
            return false;
        }
        if (deleteCollisionsFrom == null || deleteCollisionsTo == null) {
            logger.warn("isCreateCollisionSuppressed: Only one of the two properties '{}' and '{}' is set! To enable the collision suppression, both must be set and the current timestamp must match. Ignoring this completely and returning false!", (Object)CONFIG_KEY_DELETE_COLLISIONS_FROM, (Object)CONFIG_KEY_DELETE_COLLISIONS_TO);
            return false;
        }
        Date now = new Date();
        if (now.before(deleteCollisionsFrom)) {
            return false;
        }
        return now.before(deleteCollisionsTo);
    }

    public Date[] getDeleteCollisionsFromInclToExclRange() {
        Date deleteCollisionsFrom = this.getDeleteCollisionsFrom();
        Date deleteCollisionsTo = this.getDeleteCollisionsTo();
        if (deleteCollisionsFrom == null && deleteCollisionsTo == null) {
            return null;
        }
        if (deleteCollisionsFrom == null || deleteCollisionsTo == null) {
            logger.warn("getDeleteCollisionsFromInclToExclRange: Only one of the two properties '{}' and '{}' is set! To enable the collision deletion, both must be set. Ignoring this completely and returning null!", (Object)CONFIG_KEY_DELETE_COLLISIONS_FROM, (Object)CONFIG_KEY_DELETE_COLLISIONS_TO);
            return null;
        }
        return new Date[]{deleteCollisionsFrom, deleteCollisionsTo};
    }
}

