/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.repo;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.bean.AbstractBean;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.Util;
import java.util.Date;
import java.util.UUID;
import org.subshare.core.repo.ServerRepo;

public class ServerRepoImpl
extends AbstractBean<ServerRepo.Property>
implements ServerRepo {
    private final UUID repositoryId;
    private String name;
    private Uid serverId;
    private Uid userId;
    private Date changed = new Date();

    public ServerRepoImpl(UUID repositoryId) {
        this.repositoryId = (UUID)AssertUtil.assertNotNull((Object)repositoryId, (String)"repositoryId)");
    }

    @Override
    public UUID getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public synchronized String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setPropertyValue(ServerRepo.PropertyEnum.name, name);
        this.updateChanged();
    }

    @Override
    public synchronized Uid getServerId() {
        return this.serverId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServerId(Uid serverId) {
        ServerRepoImpl serverRepoImpl = this;
        synchronized (serverRepoImpl) {
            if (this.serverId != null && !Util.equal((Object)this.serverId, (Object)serverId)) {
                throw new IllegalStateException("Cannot modify serverId!");
            }
        }
        this.setPropertyValue(ServerRepo.PropertyEnum.serverId, serverId);
        this.updateChanged();
    }

    @Override
    public synchronized Uid getUserId() {
        return this.userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserId(Uid userId) {
        ServerRepoImpl serverRepoImpl = this;
        synchronized (serverRepoImpl) {
            if (this.userId != null && !Util.equal((Object)this.userId, (Object)userId)) {
                throw new IllegalStateException("Cannot modify userId!");
            }
        }
        this.setPropertyValue(ServerRepo.PropertyEnum.userId, userId);
        this.updateChanged();
    }

    @Override
    public synchronized Date getChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(Date changed) {
        AssertUtil.assertNotNull((Object)changed, (String)"changed");
        this.setPropertyValue(ServerRepo.PropertyEnum.changed, changed);
    }

    protected void updateChanged() {
        this.setChanged(new Date());
    }

    @Override
    public ServerRepo clone() {
        return (ServerRepoImpl)super.clone();
    }
}

