/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server.service;

import co.codewizards.cloudstore.core.concurrent.CallableProvider;
import co.codewizards.cloudstore.core.concurrent.DeferrableExecutor;
import co.codewizards.cloudstore.core.dto.RepoFileDto;
import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.rest.server.service.AbstractServiceWithRepoToRepoAuth;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="_RepoFileDto/{repositoryName}")
@Consumes(value={"application/xml"})
@Produces(value={"application/xml"})
public class RepoFileDtoService
extends AbstractServiceWithRepoToRepoAuth {
    private static final Logger logger = LoggerFactory.getLogger(RepoFileDtoService.class);

    public RepoFileDtoService() {
        logger.debug("<init>: created new instance");
    }

    @GET
    public RepoFileDto getRepoFileDto() {
        return this.getRepoFileDto("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{path:.*}")
    public RepoFileDto getRepoFileDto(final @PathParam(value="path") String path) {
        AssertUtil.assertNotNull((Object)path, (String)"path");
        final RepoTransport[] repoTransport = new RepoTransport[]{this.authenticateAndCreateLocalRepoTransport()};
        try {
            String callIdentifier = RepoFileDtoService.class.getName() + ".getRepoFileDto|" + this.repositoryName + '|' + this.getAuth().getUserName() + '|' + path;
            RepoFileDto repoFileDto = (RepoFileDto)DeferrableExecutor.getInstance().call(callIdentifier, (CallableProvider)new CallableProvider<RepoFileDto>(){

                public Callable<RepoFileDto> getCallable() {
                    final RepoTransport rt = repoTransport[0];
                    repoTransport[0] = null;
                    final String unprefixedPath = rt.unprefixPath(path);
                    return new Callable<RepoFileDto>(){

                        @Override
                        public RepoFileDto call() throws Exception {
                            try {
                                RepoFileDto repoFileDto;
                                RepoFileDto repoFileDto2 = repoFileDto = rt.getRepoFileDto(unprefixedPath);
                                return repoFileDto2;
                            }
                            finally {
                                rt.close();
                            }
                        }
                    };
                }
            });
            return repoFileDto;
        }
        finally {
            if (repoTransport[0] != null) {
                repoTransport[0].close();
            }
        }
    }
}

