/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.ignore;

import co.codewizards.cloudstore.core.ignore.IgnoreRule;
import co.codewizards.cloudstore.core.util.AssertUtil;
import java.util.regex.Pattern;

public class IgnoreRuleImpl
implements IgnoreRule {
    private String ignoreRuleId;
    private String namePattern;
    private String nameRegex;
    private boolean enabled;
    private boolean caseSensitive;
    private Pattern nameRegexPattern;

    @Override
    public String getIgnoreRuleId() {
        return this.ignoreRuleId;
    }

    @Override
    public void setIgnoreRuleId(String ignoreRuleId) {
        this.ignoreRuleId = ignoreRuleId;
    }

    @Override
    public String getNamePattern() {
        return this.namePattern;
    }

    @Override
    public void setNamePattern(String namePattern) {
        this.namePattern = namePattern;
        this.nameRegexPattern = null;
    }

    @Override
    public String getNameRegex() {
        return this.nameRegex;
    }

    @Override
    public void setNameRegex(String nameRegex) {
        this.nameRegex = nameRegex;
        this.nameRegexPattern = null;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.nameRegexPattern = null;
    }

    @Override
    public Pattern getNameRegexPattern() {
        if (this.nameRegexPattern == null) {
            String regex = this.getNameRegex();
            if (regex == null) {
                String pattern = this.getNamePattern();
                if (pattern == null) {
                    return null;
                }
                regex = IgnoreRuleImpl.convertPatternToRegex(pattern);
            }
            int flags = this.isCaseSensitive() ? 0 : 66;
            this.nameRegexPattern = Pattern.compile(regex, flags);
        }
        return this.nameRegexPattern;
    }

    private static String convertPatternToRegex(String pattern) {
        AssertUtil.assertNotNull(pattern, "pattern");
        StringBuilder res = new StringBuilder();
        block7: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '.': {
                    res.append("\\.");
                    continue block7;
                }
                case '+': {
                    res.append("\\+");
                    continue block7;
                }
                case '?': {
                    res.append('.');
                    continue block7;
                }
                case '*': {
                    res.append(".*");
                    continue block7;
                }
                case '\\': {
                    res.append("\\\\");
                    continue block7;
                }
                default: {
                    res.append(c);
                }
            }
        }
        return res.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(this)) + "[namePattern=" + this.namePattern + ", nameRegex=" + this.nameRegex + ", caseSensitive=" + this.caseSensitive + ", enabled=" + this.enabled + ']';
    }
}

