/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.transport;

import co.codewizards.cloudstore.core.dto.FileChunkDto;
import co.codewizards.cloudstore.core.dto.TempChunkFileDto;
import co.codewizards.cloudstore.core.dto.jaxb.TempChunkFileDtoIo;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.objectfactory.ObjectFactoryUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.util.AssertUtil;
import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.core.util.IOUtil;
import co.codewizards.cloudstore.local.transport.TempChunkFileWithDtoFile;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempChunkFileManager {
    private static final Logger logger = LoggerFactory.getLogger(TempChunkFileManager.class);
    private static final String TEMP_CHUNK_FILE_PREFIX = "chunk_";
    private static final String TEMP_CHUNK_FILE_Dto_FILE_SUFFIX = ".xml";

    protected TempChunkFileManager() {
    }

    public static TempChunkFileManager getInstance() {
        return Holder.instance;
    }

    public void writeFileDataToTempChunkFile(File destFile, long offset, byte[] fileData) {
        AssertUtil.assertNotNull((Object)destFile, (String)"destFile");
        AssertUtil.assertNotNull((Object)fileData, (String)"fileData");
        try {
            File tempChunkFile = this.createTempChunkFile(destFile, offset);
            File tempChunkFileDtoFile = this.getTempChunkFileDtoFile(tempChunkFile);
            this.deleteOrFail(tempChunkFileDtoFile);
            try (OutputStream out = StreamUtil.castStream((IOutputStream)tempChunkFile.createOutputStream());){
                out.write(fileData);
            }
            String sha1 = HashUtil.sha1((byte[])fileData);
            logger.trace("writeFileDataToTempChunkFile: Wrote {} bytes with SHA1 '{}' to '{}'.", new Object[]{fileData.length, sha1, tempChunkFile.getAbsolutePath()});
            TempChunkFileDto tempChunkFileDto = this.createTempChunkFileDto(offset, tempChunkFile, sha1);
            new TempChunkFileDtoIo().serialize((Object)tempChunkFileDto, tempChunkFileDtoFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void deleteOrFail(File file) throws IOException {
        IOUtil.deleteOrFail((File)file);
    }

    public void deleteTempChunkFilesWithoutDtoFile(Collection<TempChunkFileWithDtoFile> tempChunkFileWithDtoFiles) {
        for (TempChunkFileWithDtoFile tempChunkFileWithDtoFile : tempChunkFileWithDtoFiles) {
            File tempChunkFileDtoFile = tempChunkFileWithDtoFile.getTempChunkFileDtoFile();
            if (tempChunkFileDtoFile != null && tempChunkFileDtoFile.exists()) continue;
            File tempChunkFile = tempChunkFileWithDtoFile.getTempChunkFile();
            logger.warn("deleteTempChunkFilesWithoutDtoFile: No Dto-file for temporary chunk-file '{}'! DELETING this temporary file!", (Object)tempChunkFile.getAbsolutePath());
            try {
                this.deleteOrFail(tempChunkFile);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
    }

    public Map<Long, TempChunkFileWithDtoFile> getOffset2TempChunkFileWithDtoFile(File destFile) {
        File[] tempFiles = this.getTempDir(destFile).listFiles();
        if (tempFiles == null) {
            return Collections.emptyMap();
        }
        String destFileNameHash = HashUtil.sha1((String)destFile.getName());
        TreeMap<Long, TempChunkFileWithDtoFile> result = new TreeMap<Long, TempChunkFileWithDtoFile>();
        for (File tempFile : tempFiles) {
            boolean dtoFile;
            String tempFileName = tempFile.getName();
            if (!tempFileName.startsWith(TEMP_CHUNK_FILE_PREFIX)) continue;
            if (tempFileName.endsWith(TEMP_CHUNK_FILE_Dto_FILE_SUFFIX)) {
                dtoFile = true;
                tempFileName = tempFileName.substring(0, tempFileName.length() - TEMP_CHUNK_FILE_Dto_FILE_SUFFIX.length());
            } else {
                dtoFile = false;
            }
            int lastUnderscoreIndex = tempFileName.lastIndexOf(95);
            if (lastUnderscoreIndex < 0) {
                throw new IllegalStateException("lastUnderscoreIndex < 0 :: tempFileName='" + tempFileName + '\'');
            }
            String tempFileDestFileName = tempFileName.substring(TEMP_CHUNK_FILE_PREFIX.length(), lastUnderscoreIndex);
            if (!destFileNameHash.equals(tempFileDestFileName)) continue;
            String offsetStr = tempFileName.substring(lastUnderscoreIndex + 1);
            Long offset = Long.valueOf(offsetStr, 36);
            TempChunkFileWithDtoFile tempChunkFileWithDtoFile = (TempChunkFileWithDtoFile)result.get(offset);
            if (tempChunkFileWithDtoFile == null) {
                tempChunkFileWithDtoFile = new TempChunkFileWithDtoFile();
                result.put(offset, tempChunkFileWithDtoFile);
            }
            if (dtoFile) {
                tempChunkFileWithDtoFile.setTempChunkFileDtoFile(tempFile);
                continue;
            }
            tempChunkFileWithDtoFile.setTempChunkFile(tempFile);
        }
        return Collections.unmodifiableMap(result);
    }

    public File getTempChunkFileDtoFile(File tempChunkFile) {
        return OioFileFactory.createFile((File)tempChunkFile.getParentFile(), (String[])new String[]{tempChunkFile.getName() + TEMP_CHUNK_FILE_Dto_FILE_SUFFIX});
    }

    public synchronized File createTempChunkFile(File destFile, long offset) {
        return this.createTempChunkFile(destFile, offset, true);
    }

    protected synchronized File createTempChunkFile(File destFile, long offset, boolean createNewFile) {
        File tempDir = this.getTempDir(destFile);
        tempDir.mkdir();
        if (!tempDir.isDirectory()) {
            throw new IllegalStateException("Creating the directory failed (it does not exist after mkdir): " + tempDir.getAbsolutePath());
        }
        String destFileNameHash = HashUtil.sha1((String)destFile.getName());
        File tempFile = OioFileFactory.createFile((File)tempDir, (String[])new String[]{String.format("%s%s_%s", TEMP_CHUNK_FILE_PREFIX, destFileNameHash, Long.toString(offset, 36))});
        if (createNewFile) {
            try {
                tempFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return tempFile;
    }

    public void moveChunks(File oldDestFile, File newDestFile) {
        Map<Long, TempChunkFileWithDtoFile> offset2TempChunkFileWithDtoFile = this.getOffset2TempChunkFileWithDtoFile(oldDestFile);
        for (Map.Entry<Long, TempChunkFileWithDtoFile> entry : offset2TempChunkFileWithDtoFile.entrySet()) {
            Long offset = entry.getKey();
            TempChunkFileWithDtoFile tempChunkFileWithDtoFile = entry.getValue();
            File oldTempChunkFile = tempChunkFileWithDtoFile.getTempChunkFile();
            File newTempChunkFile = this.createTempChunkFile(newDestFile, offset, false);
            File oldTempChunkFileDtoFile = this.getTempChunkFileDtoFile(oldTempChunkFile);
            File newTempChunkFileDtoFile = this.getTempChunkFileDtoFile(newTempChunkFile);
            try {
                this.moveOrFail(oldTempChunkFileDtoFile, newTempChunkFileDtoFile);
                logger.info("Moved chunkDto from {} to {}", (Object)oldTempChunkFileDtoFile, (Object)newTempChunkFileDtoFile);
                this.moveOrFail(oldTempChunkFile, newTempChunkFile);
                logger.info("Moved chunk from {} to {}", (Object)oldTempChunkFile, (Object)newTempChunkFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void moveOrFail(File oldFile, File newFile) throws IOException {
        oldFile.move(newFile);
    }

    public synchronized void deleteTempDirIfEmpty(File destFile) {
        File tempDir = this.getTempDir(destFile);
        tempDir.delete();
    }

    public File getTempDir(File destFile) {
        AssertUtil.assertNotNull((Object)destFile, (String)"destFile");
        File parentDir = destFile.getParentFile();
        return OioFileFactory.createFile((File)parentDir, (String[])new String[]{LocalRepoManager.TEMP_DIR_NAME});
    }

    public TempChunkFileDto createTempChunkFileDto(long offset, File tempChunkFile, String sha1) {
        AssertUtil.assertNotNull((Object)tempChunkFile, (String)"tempChunkFile");
        AssertUtil.assertNotNull((Object)sha1, (String)"sha1");
        if (!tempChunkFile.exists()) {
            throw new IllegalArgumentException("The tempChunkFile does not exist: " + tempChunkFile.getAbsolutePath());
        }
        FileChunkDto fileChunkDto = new FileChunkDto();
        fileChunkDto.setOffset(offset);
        long tempChunkFileLength = tempChunkFile.length();
        if (tempChunkFileLength > Integer.MAX_VALUE) {
            throw new IllegalStateException("tempChunkFile.length > Integer.MAX_VALUE");
        }
        fileChunkDto.setLength((int)tempChunkFileLength);
        fileChunkDto.setSha1(sha1);
        TempChunkFileDto tempChunkFileDto = new TempChunkFileDto();
        tempChunkFileDto.setFileChunkDto(fileChunkDto);
        return tempChunkFileDto;
    }

    public void deleteTempChunkFiles(Collection<TempChunkFileWithDtoFile> tempChunkFileWithDtoFiles) {
        for (TempChunkFileWithDtoFile tempChunkFileWithDtoFile : tempChunkFileWithDtoFiles) {
            File tempChunkFile = tempChunkFileWithDtoFile.getTempChunkFile();
            File tempChunkFileDtoFile = tempChunkFileWithDtoFile.getTempChunkFileDtoFile();
            try {
                if (tempChunkFile != null && tempChunkFile.exists()) {
                    this.deleteOrFail(tempChunkFile);
                }
                if (tempChunkFileDtoFile == null || !tempChunkFileDtoFile.exists()) continue;
                this.deleteOrFail(tempChunkFileDtoFile);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
    }

    private static final class Holder {
        static final TempChunkFileManager instance = (TempChunkFileManager)ObjectFactoryUtil.createObject(TempChunkFileManager.class);

        private Holder() {
        }
    }
}

