/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.qtesla;

public class CommonFunction {
    public void memoryCopy(byte[] destination, int destinationOffset, byte[] source, int sourceOffset, int length) {
        if (sourceOffset + length <= source.length && destinationOffset + length <= destination.length) {
            for (int i = 0; i < length; i = (int)((short)(i + 1))) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        }
    }

    public void memoryCopy(long[] destination, int destinationOffset, long[] source, int sourceOffset, int length) {
        if (sourceOffset + length <= source.length && destinationOffset + length <= destination.length) {
            for (int i = 0; i < length; i = (int)((short)(i + 1))) {
                destination[destinationOffset + i] = source[sourceOffset + i];
            }
        }
    }

    public boolean memoryEqual(byte[] left, int leftOffset, byte[] right, int rightOffset, int length) {
        if (leftOffset + length <= left.length && rightOffset + length <= right.length) {
            for (int i = 0; i < length; i = (int)((short)(i + 1))) {
                if (left[leftOffset + i] == right[rightOffset + i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public short load16(byte[] load, int loadOffset) {
        short number = 0;
        if (load.length - loadOffset >= 2) {
            for (int i = 0; i < 2; i = (int)((short)(i + 1))) {
                number = (short)(number ^ (short)(load[loadOffset + i] & 0xFF) << 8 * i);
            }
        } else {
            for (int i = 0; i < load.length - loadOffset; i = (int)((short)(i + 1))) {
                number = (short)(number ^ (short)(load[loadOffset + i] & 0xFF) << 8 * i);
            }
        }
        return number;
    }

    public int load32(byte[] load, int loadOffset) {
        int number = 0;
        if (load.length - loadOffset >= 4) {
            for (int i = 0; i < 4; i = (int)((short)(i + 1))) {
                number ^= (load[loadOffset + i] & 0xFF) << 8 * i;
            }
        } else {
            for (int i = 0; i < load.length - loadOffset; i = (int)((short)(i + 1))) {
                number ^= (load[loadOffset + i] & 0xFF) << 8 * i;
            }
        }
        return number;
    }

    public long load64(byte[] load, int loadOffset) {
        long number = 0L;
        if (load.length - loadOffset >= 8) {
            for (int i = 0; i < 8; i = (int)((short)(i + 1))) {
                number ^= (long)((short)(load[loadOffset + i] & 0xFF) << 8 * i);
            }
        } else {
            for (int i = 0; i < load.length - loadOffset; i = (int)((short)(i + 1))) {
                number ^= (long)(load[loadOffset + i] & 0xFF) << 8 * i;
            }
        }
        return number;
    }

    public void store16(byte[] store, int storeOffset, short number) {
        if (store.length - storeOffset >= 2) {
            for (int i = 0; i < 2; i = (int)((short)(i + 1))) {
                store[storeOffset + i] = (byte)(number >> 8 * i & 0xFF);
            }
        } else {
            for (int i = 0; i < store.length - storeOffset; i = (int)((short)(i + 1))) {
                store[storeOffset + i] = (byte)(number >> 8 * i & 0xFF);
            }
        }
    }

    public void store32(byte[] store, int storeOffset, int number) {
        if (store.length - storeOffset >= 4) {
            for (int i = 0; i < 4; i = (int)((short)(i + 1))) {
                store[storeOffset + i] = (byte)(number >> 8 * i & 0xFF);
            }
        } else {
            for (int i = 0; i < store.length - storeOffset; i = (int)((short)(i + 1))) {
                store[storeOffset + i] = (byte)(number >> 8 * i & 0xFF);
            }
        }
    }

    public void store64(byte[] store, int storeOffset, long number) {
        if (store.length - storeOffset >= 8) {
            for (int i = 0; i < 8; i = (int)((short)(i + 1))) {
                store[storeOffset + i] = (byte)(number >> 8 * i & 0xFFL);
            }
        } else {
            for (int i = 0; i < store.length - storeOffset; i = (int)((short)(i + 1))) {
                store[storeOffset + i] = (byte)(number >> 8 * i & 0xFFL);
            }
        }
    }
}

