/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.maintree;

import co.codewizards.cloudstore.core.collection.ListMerger;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.subshare.core.repo.ServerRepo;
import org.subshare.core.repo.listener.LocalRepoCommitEventListener;
import org.subshare.core.repo.listener.LocalRepoCommitEventManager;
import org.subshare.core.repo.listener.WeakLocalRepoCommitEventListener;
import org.subshare.core.repo.metaonly.ServerRepoFile;
import org.subshare.core.repo.metaonly.ServerRepoFileType;
import org.subshare.core.server.Server;
import org.subshare.gui.concurrent.SsTask;
import org.subshare.gui.ls.LocalRepoCommitEventManagerLs;
import org.subshare.gui.maintree.MainTreeItem;
import org.subshare.gui.maintree.ServerRepoMainTreeItem;
import org.subshare.gui.serverrepo.directory.ServerRepoDirectoryPane;

public class ServerRepoDirectoryMainTreeItem
extends MainTreeItem<ServerRepoFile> {
    private static final Image icon = new Image(ServerRepoDirectoryMainTreeItem.class.getResource("server-repo-directory_16x16.png").toExternalForm());
    private boolean childrenLoaded;
    private final LocalRepoCommitEventListener localRepoCommitEventListener = event -> this.scheduleDeferredGetChildrenTimerTask();
    private final WeakLocalRepoCommitEventListener weakLocalRepoCommitEventListener;
    private static final Timer deferredGetChildrenTimer = new Timer(true);
    private TimerTask deferredGetChildrenTimerTask;

    public ServerRepoDirectoryMainTreeItem(ServerRepoFile serverRepoFile) {
        super(Objects.requireNonNull(serverRepoFile, "serverRepoFile"));
        this.setGraphic((Node)new ImageView(icon));
        UUID localRepositoryId = serverRepoFile.getLocalRepositoryId();
        LocalRepoCommitEventManager localRepoCommitEventManager = LocalRepoCommitEventManagerLs.getLocalRepoCommitEventManager();
        this.weakLocalRepoCommitEventListener = new WeakLocalRepoCommitEventListener(localRepoCommitEventManager, localRepositoryId, this.localRepoCommitEventListener);
        this.weakLocalRepoCommitEventListener.addLocalRepoCommitEventListener();
    }

    private synchronized void scheduleDeferredGetChildrenTimerTask() {
        if (this.deferredGetChildrenTimerTask != null) {
            this.deferredGetChildrenTimerTask.cancel();
            this.deferredGetChildrenTimerTask = null;
        }
        this.deferredGetChildrenTimerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ServerRepoDirectoryMainTreeItem serverRepoDirectoryMainTreeItem = ServerRepoDirectoryMainTreeItem.this;
                synchronized (serverRepoDirectoryMainTreeItem) {
                    ServerRepoDirectoryMainTreeItem.this.deferredGetChildrenTimerTask = null;
                }
                Platform.runLater(() -> {
                    if (ServerRepoDirectoryMainTreeItem.this.childrenLoaded) {
                        ServerRepoDirectoryMainTreeItem.this.childrenLoaded = false;
                        if (ServerRepoDirectoryMainTreeItem.this.isExpanded()) {
                            ServerRepoDirectoryMainTreeItem.this.getChildren();
                        }
                    }
                });
            }
        };
        deferredGetChildrenTimer.schedule(this.deferredGetChildrenTimerTask, 500L);
    }

    public Server getServer() {
        return this.getServerRepoFile().getServer();
    }

    @Override
    protected String getValueString() {
        String localName = this.getServerRepoFile().getLocalName();
        return StringUtil.isEmpty((String)localName) ? "/" : localName;
    }

    public ServerRepoFile getServerRepoFile() {
        return (ServerRepoFile)this.getValueObject();
    }

    public ServerRepo getServerRepo() {
        TreeItem parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("parent == null");
        }
        if (parent instanceof ServerRepoDirectoryMainTreeItem) {
            return ((ServerRepoDirectoryMainTreeItem)parent).getServerRepo();
        }
        if (parent instanceof ServerRepoMainTreeItem) {
            return ((ServerRepoMainTreeItem)parent).getServerRepo();
        }
        throw new IllegalStateException("parent is an instance of an unexpected type: " + parent.getClass().getName());
    }

    public ObservableList<TreeItem<String>> getChildren() {
        final ObservableList children = super.getChildren();
        if (!this.childrenLoaded) {
            this.childrenLoaded = true;
            new Service<List<TreeItem<String>>>(){

                protected Task<List<TreeItem<String>>> createTask() {
                    return new SsTask<List<TreeItem<String>>>(){

                        protected List<TreeItem<String>> call() throws Exception {
                            return ServerRepoDirectoryMainTreeItem.this.loadChildren();
                        }

                        protected void succeeded() {
                            List c;
                            try {
                                c = (List)this.get();
                            }
                            catch (InterruptedException | ExecutionException e) {
                                throw new RuntimeException(e);
                            }
                            new ChildrenListMerger().merge(c, (List)children);
                        }
                    };
                }
            }.start();
        }
        return children;
    }

    public boolean isLeaf() {
        return false;
    }

    private List<TreeItem<String>> loadChildren() {
        List childServerRepoFiles = this.getServerRepoFile().getChildren();
        if (childServerRepoFiles == null) {
            return null;
        }
        ArrayList<ServerRepoFile> filtered = new ArrayList<ServerRepoFile>(childServerRepoFiles.size());
        for (ServerRepoFile childServerRepoFile : childServerRepoFiles) {
            if (childServerRepoFile.getType() != ServerRepoFileType.DIRECTORY) continue;
            filtered.add(childServerRepoFile);
        }
        Collections.sort(filtered, (o1, o2) -> o1.getLocalName().compareTo(o2.getLocalName()));
        ArrayList<TreeItem<String>> result = new ArrayList<TreeItem<String>>(filtered.size());
        for (ServerRepoFile childServerRepoFile : filtered) {
            result.add(new ServerRepoDirectoryMainTreeItem(childServerRepoFile));
        }
        return result;
    }

    @Override
    protected Parent createMainDetailContent() {
        return new ServerRepoDirectoryPane(this.getServerRepoFile());
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    private class ChildrenListMerger
    extends ListMerger<TreeItem<String>, Long> {
        private ChildrenListMerger() {
        }

        protected Long getKey(TreeItem<String> element) {
            ServerRepoDirectoryMainTreeItem item = (ServerRepoDirectoryMainTreeItem)element;
            ServerRepoFile serverRepoFile = item.getServerRepoFile();
            return serverRepoFile.getRepoFileId();
        }

        protected void update(List<TreeItem<String>> dest, int index, TreeItem<String> sourceElement, TreeItem<String> destElement) {
            ServerRepoDirectoryMainTreeItem sourceItem = (ServerRepoDirectoryMainTreeItem)sourceElement;
            ServerRepoDirectoryMainTreeItem destItem = (ServerRepoDirectoryMainTreeItem)destElement;
            destItem.setValueObject(sourceItem.getValueObject());
        }
    }
}

