/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.keytree;

import co.codewizards.cloudstore.core.bean.Bean;
import co.codewizards.cloudstore.core.bean.PropertyBase;
import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import co.codewizards.cloudstore.core.bean.WeakPropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Objects;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpSignature;
import org.subshare.gui.ls.PgpLs;
import org.subshare.gui.pgp.keytree.CertificationPgpKeyTreeItem;
import org.subshare.gui.pgp.keytree.PgpKeyTreeItem;
import org.subshare.gui.util.PlatformUtil;

public class CertificationsPgpKeyTreeItem
extends PgpKeyTreeItem<PgpKey> {
    private final String userId;
    private boolean childrenInitialised;
    private final PropertyChangeListener pgpPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Platform.runLater(() -> CertificationsPgpKeyTreeItem.this.updateChildren());
        }
    };
    private WeakPropertyChangeListener pgpWeakPropertyChangeListener;

    private void updateChildren() {
        if (this.childrenInitialised) {
            this.childrenInitialised = false;
            super.getChildren().clear();
            if (this.isExpanded()) {
                this.getChildren();
            } else {
                this.unhookPgpPropertyChangeListener();
            }
        }
    }

    public CertificationsPgpKeyTreeItem(PgpKey pgpKey, String userId) {
        super(Objects.requireNonNull(pgpKey, "pgpKey"));
        this.userId = Objects.requireNonNull(userId, "userId");
    }

    public ObservableList<TreeItem<PgpKeyTreeItem<?>>> getChildren() {
        ObservableList children = super.getChildren();
        if (!this.childrenInitialised) {
            this.childrenInitialised = true;
            this.hookPgpPropertyChangeListener();
            Pgp pgp = PgpLs.getPgpOrFail();
            PgpKey pgpKey = (PgpKey)this.getValueObject();
            Collection signatures = pgp.getCertifications(pgpKey);
            for (PgpSignature signature : signatures) {
                if (signature.getUserId() != null && !this.userId.equals(signature.getUserId())) continue;
                this.getChildren().add((Object)new CertificationPgpKeyTreeItem(pgp, signature));
            }
        }
        return children;
    }

    public boolean isLeaf() {
        return false;
    }

    @Override
    public String getName() {
        return "Certifications";
    }

    @Override
    protected void onPgpInvalidated() {
        if (this.unhookPgpPropertyChangeListener()) {
            this.hookPgpPropertyChangeListener();
        }
        super.onPgpInvalidated();
    }

    protected void hookPgpPropertyChangeListener() {
        PlatformUtil.assertFxApplicationThread();
        if (this.pgpWeakPropertyChangeListener == null) {
            Pgp pgp = Objects.requireNonNull(this.getPgp(), "pgp");
            this.pgpWeakPropertyChangeListener = PropertyChangeListenerUtil.addWeakPropertyChangeListener((Bean)pgp, (PropertyBase)Pgp.PropertyEnum.localRevision, (PropertyChangeListener)this.pgpPropertyChangeListener);
        }
    }

    protected boolean unhookPgpPropertyChangeListener() {
        PlatformUtil.assertFxApplicationThread();
        if (this.pgpWeakPropertyChangeListener != null) {
            this.pgpWeakPropertyChangeListener.removePropertyChangeListener();
            this.pgpWeakPropertyChangeListener = null;
            return true;
        }
        return false;
    }
}

