/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.wizard;

import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.gui.wizard.CompletableContent;
import org.subshare.gui.wizard.Wizard;

public abstract class WizardPage
extends VBox {
    private static final Logger logger = LoggerFactory.getLogger(WizardPage.class);
    private String title;
    private Wizard wizard;
    protected Parent content;
    protected final Button previousButton = new Button("P_revious");
    protected final Button nextButton = new Button("N_ext");
    protected final Button cancelButton = new Button("Cancel");
    protected final Button finishButton = new Button("_Finish");
    protected final BooleanProperty shown = new SimpleBooleanProperty((Object)this, "shown");
    protected final BooleanProperty shownRequired = new SimpleBooleanProperty((Object)this, "shownRequired");
    protected final BooleanProperty shownOrNotShownRequired = new SimpleBooleanProperty((Object)this, "shownOrNotShownRequired");
    private final ObjectProperty<WizardPage> nextPage = new SimpleObjectProperty<WizardPage>((Object)this, "nextPage"){

        public void set(WizardPage newValue) {
            super.set((Object)newValue);
            Wizard wizard = WizardPage.this.getWizard();
            if (wizard != null && newValue != null && wizard != newValue.getWizard()) {
                newValue.setWizard(wizard);
            }
            if (wizard != null) {
                wizard.updateCanFinish();
            }
            WizardPage.this.updateButtonsDisable();
        }
    };
    private final BooleanProperty completeProperty = new SimpleBooleanProperty((Object)this, "complete", true){

        protected void invalidated() {
            WizardPage.this.updateButtonsDisable();
        }
    };

    protected WizardPage(String title) {
        this.title = title;
        this.setId(((Object)((Object)this)).getClass().getSimpleName());
        this.setSpacing(5.0);
        this.setStyle("-fx-padding:0; -fx-background-color: honeydew; -fx-border-color: derive(honeydew, -30%); -fx-border-width: 3;");
        this.previousButton.setOnAction(event -> this.getWizard().navToPreviousPage());
        this.previousButton.setGraphic((Node)new ImageView(WizardPage.class.getResource("left_24x24.png").toExternalForm()));
        this.nextButton.setOnAction(event -> this.getWizard().navToNextPage());
        this.nextButton.setGraphic((Node)new ImageView(WizardPage.class.getResource("right_24x24.png").toExternalForm()));
        this.cancelButton.setOnAction(event -> this.getWizard().cancel());
        this.cancelButton.setGraphic((Node)new ImageView(WizardPage.class.getResource("cancel_24x24.png").toExternalForm()));
        this.finishButton.setOnAction(event -> this.getWizard().finish());
        this.finishButton.setGraphic((Node)new ImageView(WizardPage.class.getResource("ok_24x24.png").toExternalForm()));
        this.finishButton.disabledProperty().addListener(observable -> {
            if (this.finishButton.disabledProperty().get()) {
                this.finishButton.setDefaultButton(false);
                this.nextButton.setDefaultButton(true);
            } else {
                this.nextButton.setDefaultButton(false);
                this.finishButton.setDefaultButton(true);
            }
        });
        this.shownOrNotShownRequired.bind((ObservableValue)this.shown.or((ObservableBooleanValue)this.shownRequired.not()));
        this.shown.addListener(observable -> logger.debug("shown={}", (Object)this.shown.get()));
        this.addEventFilter(KeyEvent.KEY_RELEASED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (!event.isAltDown()) {
                    return;
                }
                switch (event.getCode()) {
                    case LEFT: {
                        if (!WizardPage.this.previousButton.isDisabled()) {
                            WizardPage.this.getWizard().navToPreviousPage();
                        }
                        event.consume();
                        break;
                    }
                    case RIGHT: {
                        if (!WizardPage.this.nextButton.isDisabled()) {
                            WizardPage.this.getWizard().navToNextPage();
                        }
                        event.consume();
                        break;
                    }
                }
            }
        });
    }

    public String getTitle() {
        return this.title;
    }

    private HBox createButtonBar() {
        Region spring = new Region();
        HBox.setHgrow((Node)spring, (Priority)Priority.ALWAYS);
        HBox buttonBar = new HBox(5.0);
        this.cancelButton.setCancelButton(true);
        this.finishButton.setDefaultButton(true);
        buttonBar.getChildren().addAll((Object[])new Node[]{spring, this.previousButton, this.nextButton, this.cancelButton, this.finishButton, new Region()});
        return buttonBar;
    }

    public void setWizard(Wizard wizard) {
        Objects.requireNonNull(wizard, "wizard");
        if (this.wizard == wizard) {
            return;
        }
        if (this.wizard != null) {
            throw new IllegalStateException("this.wizard != null :: Cannot re-use WizardPage in another Wizard!");
        }
        this.wizard = wizard;
        Region spring = new Region();
        VBox.setVgrow((Node)spring, (Priority)Priority.ALWAYS);
        this.content = this.createContent();
        if (this.content == null) {
            this.content = new HBox(new Node[]{new Text(String.format(">>> NO CONTENT <<<\n\nYour implementation of WizardPage.createContent() in class\n%s\nreturned null!", ((Object)((Object)this)).getClass().getName()))});
        }
        if (this.content instanceof CompletableContent) {
            ReadOnlyBooleanProperty contentCompleteProperty = ((CompletableContent)this.content).completeProperty();
            Objects.requireNonNull(contentCompleteProperty, "content.completeProperty()");
            this.completeProperty().bind((ObservableValue)contentCompleteProperty.and((ObservableBooleanValue)this.shownOrNotShownRequired));
        }
        this.getChildren().add((Object)this.content);
        this.getChildren().addAll((Object[])new Node[]{spring, this.createButtonBar(), new Region()});
        this.finishButton.disableProperty().bind((ObservableValue)wizard.canFinishProperty().not());
        this.init();
        wizard.registerWizardPage(this);
        WizardPage nextPage = this.getNextPage();
        if (nextPage != null) {
            nextPage.setWizard(wizard);
        }
    }

    protected void init() {
    }

    protected void onShown() {
        this.shown.set(true);
    }

    protected void onHidden() {
    }

    protected abstract Parent createContent();

    protected boolean hasNextPage() {
        return this.getNextPage() != null;
    }

    protected boolean hasPreviousPage() {
        if (this.getWizard() == null) {
            return false;
        }
        return this.getWizard().hasPreviousPage();
    }

    public ObjectProperty<WizardPage> nextPageProperty() {
        return this.nextPage;
    }

    public WizardPage getNextPage() {
        return (WizardPage)((Object)this.nextPage.get());
    }

    public void setNextPage(WizardPage wizardPage) {
        this.nextPage.set((Object)wizardPage);
    }

    protected Wizard getWizard() {
        return this.wizard;
    }

    public BooleanProperty completeProperty() {
        return this.completeProperty;
    }

    public boolean isComplete() {
        return this.completeProperty.get();
    }

    public void setComplete(boolean complete) {
        this.completeProperty.set(complete);
    }

    public void updateButtonsDisable() {
        this.previousButton.setDisable(!this.hasPreviousPage());
        this.nextButton.setDisable(!this.hasNextPage() || !this.completeProperty.get());
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.content != null) {
            this.content.requestFocus();
        }
    }
}

