/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp.gnupg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.wot.TrustDb;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyAlgorithm;
import org.subshare.core.pgp.PgpKeyFingerprint;
import org.subshare.core.pgp.PgpKeyFlag;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.gnupg.BcWithLocalGnuPgPgp;

public class BcPgpKey {
    private final BcWithLocalGnuPgPgp pgp;
    private final PgpKeyId pgpKeyId;
    private PGPPublicKeyRing publicKeyRing;
    private PGPSecretKeyRing secretKeyRing;
    private PGPPublicKey publicKey;
    private PGPSecretKey secretKey;
    private BcPgpKey masterKey;
    private Set<PgpKeyId> subKeyIds;
    private PgpKey pgpKey;

    public BcPgpKey(BcWithLocalGnuPgPgp pgp, PgpKeyId pgpKeyId) {
        this.pgp = pgp;
        this.pgpKeyId = Objects.requireNonNull(pgpKeyId, "pgpKeyId");
    }

    public PgpKeyId getPgpKeyId() {
        return this.pgpKeyId;
    }

    public PGPPublicKeyRing getPublicKeyRing() {
        return this.publicKeyRing;
    }

    public void setPublicKeyRing(PGPPublicKeyRing publicKeyRing) {
        this.publicKeyRing = publicKeyRing;
    }

    public PGPSecretKeyRing getSecretKeyRing() {
        return this.secretKeyRing;
    }

    public void setSecretKeyRing(PGPSecretKeyRing secretKeyRing) {
        this.secretKeyRing = secretKeyRing;
    }

    public PGPPublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PGPPublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public PGPSecretKey getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(PGPSecretKey secretKey) {
        this.secretKey = secretKey;
    }

    public BcPgpKey getMasterKey() {
        return this.masterKey;
    }

    public void setMasterKey(BcPgpKey masterKey) {
        this.masterKey = masterKey;
    }

    public Set<PgpKeyId> getSubKeyIds() {
        if (this.subKeyIds == null && this.masterKey == null) {
            this.subKeyIds = new LinkedHashSet<PgpKeyId>();
        }
        return this.subKeyIds;
    }

    public synchronized PgpKey getPgpKey() {
        PgpKey masterPgpKey;
        PgpKey pgpKey = masterPgpKey = this.masterKey == null ? null : this.masterKey.getPgpKey();
        if (this.pgpKey == null) {
            boolean disabled;
            byte[] fingerprint = Objects.requireNonNull(this.publicKey, "publicKey").getFingerprint();
            boolean secretKeyAvailable = this.secretKey != null && !this.secretKey.isPrivateKeyEmpty();
            ArrayList<String> userIds = new ArrayList<String>();
            Iterator itUserIDs = this.publicKey.getUserIDs();
            while (itUserIDs.hasNext()) {
                userIds.add((String)itUserIDs.next());
            }
            long validSeconds = this.publicKey.getValidSeconds();
            Date created = this.publicKey.getCreationTime();
            Date validTo = validSeconds < 1L ? null : new Date(created.getTime() + validSeconds * 1000L);
            TrustDb trustDb = this.pgp.createTrustDb();
            Object object = null;
            try {
                disabled = trustDb.isDisabled(masterPgpKey == null ? this.publicKey : this.masterKey.getPublicKey());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (trustDb != null) {
                    if (object != null) {
                        try {
                            trustDb.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        trustDb.close();
                    }
                }
            }
            this.pgpKey = new PgpKey(this.pgpKeyId, new PgpKeyFingerprint(fingerprint), masterPgpKey, created, validTo, this.getPgpKeyAlgorithm(this.publicKey.getAlgorithm()), this.publicKey.getBitStrength(), secretKeyAvailable, userIds, this.getPgpKeyFlags(), this.publicKey.isRevoked(), disabled);
            this.getSubKeyIds();
            if (this.subKeyIds == null) {
                this.pgpKey.setSubKeys(null);
            } else {
                this.subKeyIds = Collections.unmodifiableSet(new LinkedHashSet<PgpKeyId>(this.subKeyIds));
                ArrayList<PgpKey> subKeys = new ArrayList<PgpKey>(this.subKeyIds.size());
                for (PgpKeyId subKeyId : this.subKeyIds) {
                    BcPgpKey subKey = this.pgp.getBcPgpKey(subKeyId);
                    if (subKey == null) {
                        throw new IllegalStateException("Key not found: " + subKeyId);
                    }
                    subKeys.add(subKey.getPgpKey());
                }
                this.pgpKey.setSubKeys(subKeys);
            }
        }
        return this.pgpKey;
    }

    private PgpKeyAlgorithm getPgpKeyAlgorithm(int algorithm) {
        switch (algorithm) {
            case 1: 
            case 2: 
            case 3: {
                return PgpKeyAlgorithm.RSA;
            }
            case 17: {
                return PgpKeyAlgorithm.DSA;
            }
            case 18: {
                return PgpKeyAlgorithm.ECDH;
            }
            case 19: {
                return PgpKeyAlgorithm.ECDSA;
            }
            case 16: 
            case 20: {
                return PgpKeyAlgorithm.EL_GAMAL;
            }
            case 21: {
                return PgpKeyAlgorithm.DIFFIE_HELLMAN;
            }
        }
        throw new IllegalArgumentException("Unknown algorithm: " + algorithm);
    }

    private Set<PgpKeyFlag> getPgpKeyFlags() {
        EnumSet<PgpKeyFlag> result = EnumSet.noneOf(PgpKeyFlag.class);
        PgpKeyId masterKeyId = this.masterKey == null ? this.getPgpKeyId() : this.masterKey.getPgpKeyId();
        Iterator sigIt = this.publicKey.getSignatures();
        while (sigIt.hasNext()) {
            PGPSignatureSubpacketVector hashedSubPackets;
            PGPSignature signature = (PGPSignature)sigIt.next();
            if (signature.getKeyID() != masterKeyId.longValue() || (hashedSubPackets = signature.getHashedSubPackets()) == null) continue;
            int keyFlags = hashedSubPackets.getKeyFlags();
            result.addAll(BcPgpKey.getPgpKeyFlags(keyFlags));
        }
        return result;
    }

    private static Set<PgpKeyFlag> getPgpKeyFlags(int keyFlags) {
        EnumSet<PgpKeyFlag> result = EnumSet.noneOf(PgpKeyFlag.class);
        if ((keyFlags & 1) != 0) {
            result.add(PgpKeyFlag.CAN_CERTIFY);
        }
        if ((keyFlags & 2) != 0) {
            result.add(PgpKeyFlag.CAN_SIGN);
        }
        if ((keyFlags & 0x20) != 0) {
            result.add(PgpKeyFlag.CAN_AUTHENTICATE);
        }
        if ((keyFlags & 4) != 0) {
            result.add(PgpKeyFlag.CAN_ENCRYPT_COMMS);
        }
        if ((keyFlags & 8) != 0) {
            result.add(PgpKeyFlag.CAN_ENCRYPT_STORAGE);
        }
        if ((keyFlags & 0x10) != 0) {
            result.add(PgpKeyFlag.MAYBE_SPLIT);
        }
        if ((keyFlags & 0x80) != 0) {
            result.add(PgpKeyFlag.MAYBE_SHARED);
        }
        return result;
    }
}

