/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.rest.server.service;

import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.rest.server.service.AbstractServiceWithRepoToRepoAuth;
import java.util.Objects;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="_beginPutFile/{repositoryName}")
@Consumes(value={"application/xml"})
@Produces(value={"application/xml"})
public class BeginPutFileService
extends AbstractServiceWithRepoToRepoAuth {
    private static final Logger logger = LoggerFactory.getLogger(BeginPutFileService.class);

    public BeginPutFileService() {
        logger.debug("<init>: created new instance");
    }

    @PUT
    @Path(value="{path:.*}")
    public void beginPutFile(@PathParam(value="path") String path) {
        Objects.requireNonNull(path, "path");
        try (RepoTransport repoTransport = this.authenticateAndCreateLocalRepoTransport();){
            path = repoTransport.unprefixPath(path);
            repoTransport.beginPutFile(path);
        }
    }
}

