/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.locker.transport.local;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.auth.SignatureException;
import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.io.ByteArrayOutputStream;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.io.LockFile;
import co.codewizards.cloudstore.core.io.LockFileFactory;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.subshare.core.locker.LockerContent;
import org.subshare.core.locker.LockerEncryptedDataFile;
import org.subshare.core.locker.transport.AbstractLockerTransport;
import org.subshare.core.pgp.PgpDecoder;
import org.subshare.core.pgp.PgpEncoder;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.PgpSignature;

public class LocalLockerTransport
extends AbstractLockerTransport {
    private File localLockerTransportPropertiesFile;
    private Properties localLockerTransportProperties;
    private final Set<Uid> mergedVersions = new LinkedHashSet<Uid>();

    @Override
    public List<Uid> getVersions() {
        return Collections.singletonList(this.getVersion());
    }

    @Override
    public void setLockerContent(LockerContent lockerContent) {
        super.setLockerContent(lockerContent);
        this.mergedVersions.clear();
    }

    @Override
    public void setPgpKey(PgpKey pgpKey) {
        super.setPgpKey(pgpKey);
        this.mergedVersions.clear();
    }

    @Override
    public void addMergedVersions(List<Uid> serverVersions) {
        Objects.requireNonNull(serverVersions, "serverVersions");
        this.mergedVersions.addAll(serverVersions);
    }

    protected Uid getVersion() {
        Uid persistentServerVersion;
        LockerContent lockerContent = this.getLockerContentOrFail();
        Uid lockerContentLocalVersion = lockerContent.getLocalVersion();
        if (lockerContentLocalVersion == null) {
            throw new IllegalStateException(String.format("Implementation error: %s.getLocalVersion() returned null! ", lockerContent.getClass().getName()));
        }
        String s = this.getLocalLockerTransportProperties().getProperty(this.getLocalVersionPropertyKey());
        Uid persistentLocalVersion = StringUtil.isEmpty((String)s) ? null : new Uid(s);
        s = this.getLocalLockerTransportProperties().getProperty(this.getServerVersionPropertyKey());
        Uid uid = persistentServerVersion = StringUtil.isEmpty((String)s) ? null : new Uid(s);
        if (!lockerContentLocalVersion.equals((Object)persistentLocalVersion) || persistentServerVersion == null) {
            persistentLocalVersion = lockerContentLocalVersion;
            persistentServerVersion = new Uid();
            this.getLocalLockerTransportProperties().setProperty(this.getLocalVersionPropertyKey(), persistentLocalVersion.toString());
            this.getLocalLockerTransportProperties().setProperty(this.getServerVersionPropertyKey(), persistentServerVersion.toString());
            this.writeLocalLockerTransportProperties();
        }
        return persistentServerVersion;
    }

    public String getLocalVersionPropertyKey() {
        PgpKeyId pgpKeyId = this.getPgpKeyOrFail().getPgpKeyId();
        return String.format("pgpKey[%s].lockerContent[%s].localVersion", pgpKeyId, this.getLockerContentOrFail().getName());
    }

    public String getServerVersionPropertyKey() {
        PgpKeyId pgpKeyId = this.getPgpKeyOrFail().getPgpKeyId();
        return String.format("pgpKey[%s].lockerContent[%s].serverVersion", pgpKeyId, this.getLockerContentOrFail().getName());
    }

    @Override
    public List<LockerEncryptedDataFile> getEncryptedDataFiles() {
        LockerContent lockerContent = this.getLockerContentOrFail();
        PgpKey pgpKey = this.getPgpKeyOrFail();
        LockerEncryptedDataFile encryptedDataFile = new LockerEncryptedDataFile();
        encryptedDataFile.setContentName(lockerContent.getName());
        encryptedDataFile.setContentVersion(this.getVersion());
        encryptedDataFile.setReplacedContentVersions(this.mergedVersions);
        try {
            encryptedDataFile.signManifestData(pgpKey);
            byte[] localData = lockerContent.getLocalData();
            if (localData == null) {
                throw new IllegalStateException(String.format("Implementation error: %s.getLocalData() returned null! ", lockerContent.getClass().getName()));
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PgpEncoder encoder = this.getPgp().createEncoder((IInputStream)new ByteArrayInputStream(localData), (IOutputStream)out);
            encoder.getEncryptPgpKeys().add(pgpKey);
            encoder.setSignPgpKey(pgpKey);
            encoder.encode();
            encryptedDataFile.putDefaultData(out.toByteArray());
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        return Collections.singletonList(encryptedDataFile);
    }

    @Override
    public void putEncryptedDataFile(LockerEncryptedDataFile encryptedDataFile) {
        Objects.requireNonNull(encryptedDataFile, "encryptedDataFile");
        Uid contentVersion = encryptedDataFile.getContentVersion();
        Objects.requireNonNull(contentVersion, "encryptedDataFile.contentVersion");
        PgpSignature manifestSignature = encryptedDataFile.assertManifestSignatureValid();
        PgpKeyId pgpKeyId = this.getPgpKeyOrFail().getPgpKeyId();
        PgpKey manifestSignatureKey = this.getPgp().getPgpKey(manifestSignature.getPgpKeyId());
        if (manifestSignatureKey == null) {
            throw new IllegalStateException(String.format("PGP key (used for signing the manifest) not found: %s", manifestSignature.getPgpKeyId()));
        }
        if (!pgpKeyId.equals((manifestSignatureKey = manifestSignatureKey.getMasterKey()).getPgpKeyId())) {
            throw new IllegalStateException(String.format("pgpKeyId != manifestSignatureKey.pgpKeyId :: %s != %s", pgpKeyId, manifestSignature.getPgpKeyId()));
        }
        if (this.mergedVersions.contains(contentVersion)) {
            return;
        }
        try {
            byte[] defaultData = encryptedDataFile.getDefaultData();
            Objects.requireNonNull(defaultData, "encryptedDataFile.defaultData");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PgpDecoder decoder = this.getPgp().createDecoder((IInputStream)new ByteArrayInputStream(defaultData), (IOutputStream)out);
            decoder.decode();
            PgpSignature defaultDataSignature = decoder.getPgpSignature();
            if (defaultDataSignature == null) {
                throw new SignatureException("Missing signature!");
            }
            if (decoder.getDecryptPgpKey() == null) {
                throw new IllegalStateException("WTF?! The data was not encrypted!");
            }
            PgpKey defaultDataSignatureKey = this.getPgp().getPgpKey(defaultDataSignature.getPgpKeyId());
            if (defaultDataSignatureKey == null) {
                throw new IllegalStateException(String.format("PGP key (used for signing the default-data) not found: %s", defaultDataSignature.getPgpKeyId()));
            }
            if (!pgpKeyId.equals((defaultDataSignatureKey = defaultDataSignatureKey.getMasterKey()).getPgpKeyId())) {
                throw new IllegalStateException(String.format("pgpKeyId != defaultDataSignature.pgpKeyId :: %s != %s", pgpKeyId, defaultDataSignature.getPgpKeyId()));
            }
            this.getLockerContentOrFail().mergeFrom(out.toByteArray());
            this.mergedVersions.add(contentVersion);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    private File getLocalLockerTransportPropertiesFile() {
        if (this.localLockerTransportPropertiesFile == null) {
            this.localLockerTransportPropertiesFile = OioFileFactory.createFile((File)ConfigDir.getInstance().getFile(), (String[])new String[]{"localLockerTransport.properties"});
        }
        return this.localLockerTransportPropertiesFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getLocalLockerTransportProperties() {
        block30: {
            if (this.localLockerTransportProperties == null) {
                try (LockFile lockFile = LockFileFactory.getInstance().acquire(this.getLocalLockerTransportPropertiesFile(), 30000L);){
                    Lock lock = lockFile.getLock();
                    lock.lock();
                    try {
                        if (this.localLockerTransportProperties != null) break block30;
                        Properties p = new Properties();
                        try (InputStream in = StreamUtil.castStream((IInputStream)lockFile.createInputStream());){
                            p.load(in);
                        }
                        this.localLockerTransportProperties = p;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                catch (IOException x) {
                    throw new RuntimeException(x);
                }
            }
        }
        return this.localLockerTransportProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLocalLockerTransportProperties() {
        Properties localLockerTransportProperties;
        Properties properties = localLockerTransportProperties = this.getLocalLockerTransportProperties();
        synchronized (properties) {
            try (LockFile lockFile = LockFileFactory.getInstance().acquire(this.getLocalLockerTransportPropertiesFile(), 30000L);
                 OutputStream out = StreamUtil.castStream((IOutputStream)lockFile.createOutputStream());){
                localLockerTransportProperties.store(out, null);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
    }
}

