/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.expression.EnumExpression;
import org.datanucleus.store.rdbms.sql.expression.EnumLiteral;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.util.Localiser;

public class EnumOrdinalMethod
extends AbstractSQLMethod {
    @Override
    public SQLExpression getExpression(SQLExpression expr, List<SQLExpression> args) {
        if (expr instanceof EnumLiteral) {
            Enum val = (Enum)((EnumLiteral)expr).getValue();
            return new IntegerLiteral(this.stmt, this.exprFactory.getMappingForType(Integer.TYPE, false), val.ordinal(), null);
        }
        if (expr instanceof EnumExpression) {
            EnumExpression enumExpr = (EnumExpression)expr;
            JavaTypeMapping m = enumExpr.getJavaTypeMapping();
            if (m.getJavaTypeForDatastoreMapping(0).equals(ClassNameConstants.JAVA_LANG_STRING)) {
                throw new NucleusException("EnumExpression.ordinal is not supported when the enum is stored as a string");
            }
            return enumExpr.getDelegate();
        }
        throw new NucleusException(Localiser.msg((String)"060001", (Object[])new Object[]{"ordinal", expr}));
    }
}

