/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.persistence;

import co.codewizards.cloudstore.core.repo.local.DaoProvider;
import co.codewizards.cloudstore.core.util.ReflectionUtil;
import co.codewizards.cloudstore.local.ContextWithPersistenceManager;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.jdo.JDOHelper;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.jdo.identity.LongIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Dao<E extends Entity, D extends Dao<E, D>>
implements ContextWithPersistenceManager {
    private final Logger logger;
    private final Class<E> entityClass;
    private final Class<D> daoClass;
    private DaoProvider daoProvider;
    private static final int LOAD_ID_RANGE_PACKAGE_SIZE = 100;
    private static final int[] LOAD_ID_RANGE_PACKAGE_SIZES_SHRINKED = new int[]{1, 10};
    private PersistenceManager pm;
    private final Map<Class<? extends Dao<?, ?>>, Dao<?, ?>> daoClass2DaoInstance = new HashMap(3);

    public Dao() {
        Class k;
        Class c;
        Type[] actualTypeArguments = ReflectionUtil.resolveActualTypeArguments(Dao.class, (Object)this);
        if (!(actualTypeArguments[0] instanceof Class)) {
            throw new IllegalStateException("Subclass " + this.getClass().getName() + " misses generic type info for 'E'!");
        }
        this.entityClass = c = (Class)actualTypeArguments[0];
        if (this.entityClass == null) {
            throw new IllegalStateException("Subclass " + this.getClass().getName() + " has no generic type argument!");
        }
        if (!(actualTypeArguments[1] instanceof Class)) {
            throw new IllegalStateException("Subclass " + this.getClass().getName() + " misses generic type info for 'D'!");
        }
        this.daoClass = k = (Class)actualTypeArguments[1];
        if (this.daoClass == null) {
            throw new IllegalStateException("Subclass " + this.getClass().getName() + " has no generic type argument!");
        }
        this.logger = LoggerFactory.getLogger((String)String.format("%s<%s>", Dao.class.getName(), this.entityClass.getSimpleName()));
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return this.pm;
    }

    public void setPersistenceManager(PersistenceManager persistenceManager) {
        if (this.pm != persistenceManager) {
            this.daoClass2DaoInstance.clear();
            this.pm = persistenceManager;
        }
    }

    protected PersistenceManager pm() {
        if (this.pm == null) {
            throw new IllegalStateException("persistenceManager not assigned!");
        }
        return this.pm;
    }

    public DaoProvider getDaoProvider() {
        return this.daoProvider;
    }

    public void setDaoProvider(DaoProvider daoProvider) {
        this.daoProvider = daoProvider;
    }

    public D persistenceManager(PersistenceManager persistenceManager) {
        this.setPersistenceManager(persistenceManager);
        return this.thisDao();
    }

    protected D thisDao() {
        return (D)((Dao)this.daoClass.cast(this));
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public E getObjectByIdOrFail(long id) throws JDOObjectNotFoundException {
        return this.getObjectById(id, true);
    }

    public E getObjectByIdOrNull(long id) {
        return this.getObjectById(id, false);
    }

    private E getObjectById(long id, boolean throwExceptionIfNotFound) throws JDOObjectNotFoundException {
        try {
            Object result = this.pm().getObjectById((Object)new LongIdentity(this.entityClass, id));
            return (E)((Entity)this.entityClass.cast(result));
        }
        catch (JDOObjectNotFoundException x) {
            if (throwExceptionIfNotFound) {
                throw x;
            }
            return null;
        }
    }

    public Collection<E> getObjects() {
        ArrayList result = new ArrayList();
        Iterator iterator = this.pm().getExtent(this.entityClass).iterator();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    public long getObjectsCount() {
        Query query = this.pm().newQuery(this.entityClass);
        query.setResult("count(this)");
        Long result = (Long)query.execute();
        if (result == null) {
            throw new IllegalStateException("Query for count(this) returned null!");
        }
        return result;
    }

    public <P extends E> P makePersistent(P entity) {
        Objects.requireNonNull(entity, "entity");
        try {
            Entity result = (Entity)this.pm().makePersistent(entity);
            this.logger.debug("makePersistent: entityID={}", JDOHelper.getObjectId((Object)result));
            return (P)result;
        }
        catch (RuntimeException x) {
            this.logger.warn("makePersistent: FAILED for entityID={}: {}", JDOHelper.getObjectId(entity), (Object)x);
            throw x;
        }
    }

    public void deletePersistent(E entity) {
        Objects.requireNonNull(entity, "entity");
        this.logger.debug("deletePersistent: entityID={}", JDOHelper.getObjectId(entity));
        this.pm().deletePersistent(entity);
    }

    public void deletePersistentAll(Collection<? extends E> entities) {
        Objects.requireNonNull(entities, "entities");
        if (this.logger.isDebugEnabled()) {
            for (Entity entity : entities) {
                this.logger.debug("deletePersistentAll: entityID={}", JDOHelper.getObjectId((Object)entity));
            }
        }
        this.pm().deletePersistentAll(entities);
    }

    protected Collection<E> load(Collection<E> entities) {
        Objects.requireNonNull(entities, "entities");
        HashMap entityClass2EntityIds = new HashMap();
        int entitiesSize = 0;
        for (Entity entity : entities) {
            TreeSet<Long> entityIds = (TreeSet<Long>)entityClass2EntityIds.get(entity.getClass());
            if (entityIds == null) {
                entityIds = new TreeSet<Long>();
                entityClass2EntityIds.put(entity.getClass(), entityIds);
            }
            entityIds.add(entity.getId());
            ++entitiesSize;
        }
        ArrayList result = new ArrayList(entitiesSize);
        for (Map.Entry me : entityClass2EntityIds.entrySet()) {
            Class entityClass = (Class)me.getKey();
            Query query = this.pm().newQuery(this.pm().getExtent(entityClass, false));
            SortedSet entityIds = (SortedSet)me.getValue();
            List<List<IdRange>> idRangePackages = Dao.buildIdRangePackages(entityIds);
            int idRangePackageSize = Dao.shrinkIdRangePackageSizeIfPossible(idRangePackages);
            query.setFilter(this.buildIdRangePackageFilter(idRangePackageSize));
            for (List<IdRange> idRangePackage : idRangePackages) {
                Collection c = (Collection)query.executeWithMap(this.buildIdRangePackageQueryMap(idRangePackage));
                result.addAll(c);
                query.closeAll();
            }
        }
        return result;
    }

    protected <T> List<T> loadDtos(Collection<E> entities, Class<T> dtoClass, String queryResult) {
        Objects.requireNonNull(entities, "entities");
        Objects.requireNonNull(dtoClass, "dtoClass");
        HashMap entityClass2EntityIDs = new HashMap();
        int entitiesSize = 0;
        for (Entity entity : entities) {
            TreeSet<Long> entityIds = (TreeSet<Long>)entityClass2EntityIDs.get(entity.getClass());
            if (entityIds == null) {
                entityIds = new TreeSet<Long>();
                entityClass2EntityIDs.put(entity.getClass(), entityIds);
            }
            entityIds.add(entity.getId());
            ++entitiesSize;
        }
        ArrayList result = new ArrayList(entitiesSize);
        for (Map.Entry me : entityClass2EntityIDs.entrySet()) {
            Class entityClass = (Class)me.getKey();
            Query query = this.pm().newQuery(this.pm().getExtent(entityClass, false));
            query.setResultClass(dtoClass);
            query.setResult(queryResult);
            SortedSet entityIds = (SortedSet)me.getValue();
            List<List<IdRange>> idRangePackages = Dao.buildIdRangePackages(entityIds);
            int idRangePackageSize = Dao.shrinkIdRangePackageSizeIfPossible(idRangePackages);
            query.setFilter(this.buildIdRangePackageFilter(idRangePackageSize));
            for (List<IdRange> idRangePackage : idRangePackages) {
                Collection c = (Collection)query.executeWithMap(this.buildIdRangePackageQueryMap(idRangePackage));
                result.addAll(c);
                query.closeAll();
            }
        }
        return result;
    }

    protected static int shrinkIdRangePackageSizeIfPossible(List<List<IdRange>> idRangePackages) {
        Objects.requireNonNull(idRangePackages, "idRangePackages");
        if (idRangePackages.size() == 1) {
            List<IdRange> idRangePackage = idRangePackages.get(0);
            int usedIdRangeCount = 0;
            for (IdRange idRange : idRangePackage) {
                if (idRange.fromIdIncl == -1L) continue;
                ++usedIdRangeCount;
            }
            for (int idx = 0; idx < LOAD_ID_RANGE_PACKAGE_SIZES_SHRINKED.length; ++idx) {
                int result = LOAD_ID_RANGE_PACKAGE_SIZES_SHRINKED[idx];
                if (result < usedIdRangeCount) continue;
                while (idRangePackage.size() > result) {
                    idRangePackage.remove(idRangePackage.size() - 1);
                }
                return result;
            }
        }
        return 100;
    }

    protected String buildIdRangePackageFilter(int idRangePackageSize) {
        StringBuilder filter = new StringBuilder();
        for (int idx = 0; idx < idRangePackageSize; ++idx) {
            if (idx > 0) {
                filter.append(" || ");
            }
            filter.append("(:fromId").append(idx).append(" <= this.id && this.id <= :toId").append(idx).append(")");
        }
        return filter.toString();
    }

    protected Map<String, Object> buildIdRangePackageQueryMap(List<IdRange> idRangePackage) {
        Objects.requireNonNull(idRangePackage, "idRangePackage");
        HashMap<String, Object> map = new HashMap<String, Object>(idRangePackage.size() * 2);
        int idx = -1;
        for (IdRange idRange : idRangePackage) {
            map.put("fromId" + ++idx, idRange.fromIdIncl);
            map.put("toId" + idx, idRange.toIdIncl);
        }
        return map;
    }

    protected static List<List<IdRange>> buildIdRangePackages(SortedSet<Long> entityIds) {
        return Dao.buildIdRangePackages(entityIds, 100);
    }

    @Deprecated
    protected static List<List<IdRange>> buildIdRangePackages(SortedSet<Long> entityIds, int idRangePackageSize) {
        Objects.requireNonNull(entityIds, "entityIds");
        LinkedList<List<IdRange>> result = new LinkedList<List<IdRange>>();
        if (entityIds.isEmpty()) {
            return result;
        }
        ArrayList<IdRange> idRangePackage = new ArrayList<IdRange>(idRangePackageSize);
        result.add(idRangePackage);
        IdRange idRange = new IdRange();
        idRangePackage.add(idRange);
        Iterator it = entityIds.iterator();
        while (it.hasNext()) {
            long entityId = (Long)it.next();
            if (entityId < 0L) {
                throw new IllegalArgumentException("entityIds contains negative element! entityId = " + entityId);
            }
            if (!(idRange.fromIdIncl == -1L || idRange.toIdIncl + 1L == entityId && it.hasNext())) {
                if (idRange.toIdIncl + 1L == entityId) {
                    idRange.toIdIncl = entityId;
                    entityId = -1L;
                }
                if (idRangePackage.size() >= idRangePackageSize) {
                    idRangePackage = new ArrayList(idRangePackageSize);
                    result.add(idRangePackage);
                }
                idRange = new IdRange();
                idRangePackage.add(idRange);
            }
            if (idRange.fromIdIncl == -1L) {
                idRange.fromIdIncl = entityId;
            }
            idRange.toIdIncl = entityId;
        }
        if (Dao.isIdRangePackageEmpty(idRangePackage)) {
            List<IdRange> removed = result.removeLast();
            if (idRangePackage != removed) {
                throw new IllegalStateException("idRangePackage != removed");
            }
        } else {
            while (idRangePackage.size() < idRangePackageSize) {
                idRangePackage.add(new IdRange());
            }
        }
        return result;
    }

    private static boolean isIdRangePackageEmpty(List<IdRange> idRangePackage) {
        Objects.requireNonNull(idRangePackage, "idRangePackage");
        if (idRangePackage.isEmpty()) {
            return true;
        }
        IdRange idRange = idRangePackage.get(0);
        return idRange.fromIdIncl == -1L;
    }

    protected <T extends Dao<?, ?>> T getDao(Class<T> daoClass) {
        Objects.requireNonNull(daoClass, "daoClass");
        DaoProvider daoProvider = this.getDaoProvider();
        if (daoProvider != null) {
            return (T)((Dao)daoProvider.getDao(daoClass));
        }
        Dao dao = (Dao)daoClass.cast(this.daoClass2DaoInstance.get(daoClass));
        if (dao == null) {
            try {
                dao = (Dao)daoClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            dao.setPersistenceManager(this.pm);
            this.daoClass2DaoInstance.put(daoClass, dao);
        }
        return (T)dao;
    }

    protected void clearFetchGroups() {
        this.pm().getFetchPlan().setGroup("default");
    }

    protected static final class IdRange {
        public static final long NULL_ID = -1L;
        public long fromIdIncl = -1L;
        public long toIdIncl = -1L;

        protected IdRange() {
        }

        public String toString() {
            return "[" + this.fromIdIncl + ',' + this.toIdIncl + ']';
        }
    }
}

