/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp;

import co.codewizards.cloudstore.core.util.HashUtil;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.bouncycastle.bcpg.UserAttributeSubpacket;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;

public class PgpUserIdNameHash
implements Comparable<PgpUserIdNameHash>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] namehash;
    private transient int hashCode;
    private transient WeakReference<String> toString;
    private transient WeakReference<String> toHumanString;

    protected PgpUserIdNameHash(byte[] namehash) {
        Objects.requireNonNull(namehash, "namehash");
        this.namehash = namehash;
    }

    public PgpUserIdNameHash(String namehash) {
        Objects.requireNonNull(namehash, "namehash");
        this.namehash = HashUtil.decodeHexStr((String)namehash);
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.namehash, this.namehash.length);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.namehash);
        }
        return this.hashCode;
    }

    public boolean equals(byte[] namehash) {
        if (namehash == null) {
            return false;
        }
        return Arrays.equals(this.namehash, namehash);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof byte[]) {
            return this.equals((byte[])obj);
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PgpUserIdNameHash other = (PgpUserIdNameHash)obj;
        return Arrays.equals(this.namehash, other.namehash);
    }

    @Override
    public int compareTo(PgpUserIdNameHash o) {
        int res = Integer.compare(this.namehash.length, o.namehash.length);
        if (res != 0) {
            return res;
        }
        for (int i = 0; i < this.namehash.length; ++i) {
            res = Byte.compare(this.namehash[i], o.namehash[i]);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public String toString() {
        String s;
        String string = s = this.toString == null ? null : (String)this.toString.get();
        if (s == null) {
            s = HashUtil.encodeHexStr((byte[])this.namehash);
            this.toString = new WeakReference<String>(s);
        }
        return s;
    }

    public String toHumanString() {
        String s;
        String string = s = this.toHumanString == null ? null : (String)this.toHumanString.get();
        if (s == null) {
            s = this._toHumanString();
            this.toHumanString = new WeakReference<String>(s);
        }
        return s;
    }

    private String _toHumanString() {
        StringBuilder sb = new StringBuilder();
        String string = this.toString();
        for (int i = 0; i < string.length(); ++i) {
            if (i > 0 && i % 4 == 0) {
                sb.append(' ');
            }
            sb.append(string.charAt(i));
        }
        return sb.toString();
    }

    public static PgpUserIdNameHash createFromUserId(String userId) {
        Objects.requireNonNull(userId, "userId");
        RIPEMD160Digest digest = new RIPEMD160Digest();
        byte[] userIdBytes = userId.getBytes(StandardCharsets.UTF_8);
        digest.update(userIdBytes, 0, userIdBytes.length);
        byte[] out = new byte[digest.getDigestSize()];
        digest.doFinal(out, 0);
        return new PgpUserIdNameHash(out);
    }

    public static PgpUserIdNameHash createFromUserAttribute(PGPUserAttributeSubpacketVector userAttribute) {
        Objects.requireNonNull(userAttribute, "userAttribute");
        RIPEMD160Digest digest = new RIPEMD160Digest();
        UserAttributeSubpacket subpacket = userAttribute.getSubpacket(1);
        Objects.requireNonNull(subpacket, "subpacket");
        byte[] data = Objects.requireNonNull(subpacket.getData(), "subpacket.data");
        digest.update(data, 0, data.length);
        byte[] out = new byte[digest.getDigestSize()];
        digest.doFinal(out, 0);
        return new PgpUserIdNameHash(out);
    }
}

