/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.dto.PgpKeyStateDto;
import org.subshare.core.dto.PgpKeyStateRegistryDto;
import org.subshare.core.dto.jaxb.PgpKeyStateRegistryDtoIo;
import org.subshare.core.fbor.FileBasedObjectRegistry;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.PgpKeyStateRegistry;
import org.subshare.core.pgp.PgpOwnerTrust;
import org.subshare.core.pgp.PgpRegistry;

public class PgpKeyStateRegistryImpl
extends FileBasedObjectRegistry
implements PgpKeyStateRegistry {
    private static final Logger logger = LoggerFactory.getLogger(PgpKeyStateRegistryImpl.class);
    private static final String PAYLOAD_ENTRY_NAME = PgpKeyStateRegistryDto.class.getSimpleName() + ".xml";
    private final File pgpKeyStateRegistryFile;
    private final Map<PgpKeyId, PgpKeyStateDto> pgpKeyId2PgpKeyStateDto = new HashMap<PgpKeyId, PgpKeyStateDto>();
    private Uid version;
    private final Pgp pgp;
    private boolean needUpdateTrustDb;
    private final PropertyChangeListener pgpPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PgpKeyStateRegistryImpl.this.syncWithPgp();
        }
    };

    public static PgpKeyStateRegistry getInstance() {
        return Holder.instance;
    }

    public PgpKeyStateRegistryImpl() {
        this.pgpKeyStateRegistryFile = OioFileFactory.createFile((File)ConfigDir.getInstance().getFile(), (String[])new String[]{"pgpKeyStateRegistry.subshare"});
        this.read();
        this.pgp = PgpRegistry.getInstance().getPgpOrFail();
        PropertyChangeListenerUtil.addWeakPropertyChangeListener((Object)this.pgp, (PropertyChangeListener)this.pgpPropertyChangeListener);
        this.syncWithPgp();
    }

    @Override
    protected File getFile() {
        return this.pgpKeyStateRegistryFile;
    }

    @Override
    protected String getContentType() {
        return "application/vnd.subshare.pgp-key-state-registry";
    }

    @Override
    protected void preRead() {
        this.pgpKeyId2PgpKeyStateDto.clear();
        this.version = null;
    }

    @Override
    protected void postRead() {
        if (this.version == null) {
            this.markDirty();
        }
    }

    @Override
    protected void markDirty() {
        super.markDirty();
        this.version = new Uid();
    }

    @Override
    protected void readPayloadEntry(ZipInputStream zin, ZipEntry zipEntry) throws IOException {
        if (!PAYLOAD_ENTRY_NAME.equals(zipEntry.getName())) {
            logger.warn("readPayloadEntry: Ignoring unexpected zip-entry: {}", (Object)zipEntry.getName());
            return;
        }
        PgpKeyStateRegistryDtoIo pgpKeyStateRegistryDtoIo = new PgpKeyStateRegistryDtoIo();
        PgpKeyStateRegistryDto pgpKeyStateRegistryDto = (PgpKeyStateRegistryDto)pgpKeyStateRegistryDtoIo.deserialize(zin);
        for (PgpKeyStateDto pgpKeyStateDto : pgpKeyStateRegistryDto.getPgpKeyStateDtos()) {
            PgpKeyId pgpKeyId = Objects.requireNonNull(pgpKeyStateDto.getPgpKeyId(), "pgpKeyStateDto.pgpKeyId");
            this.pgpKeyId2PgpKeyStateDto.put(pgpKeyId, pgpKeyStateDto);
        }
        this.version = pgpKeyStateRegistryDto.getVersion();
    }

    @Override
    protected void writePayload(ZipOutputStream zout) throws IOException {
        PgpKeyStateRegistryDtoIo pgpKeyStateRegistryDtoIo = new PgpKeyStateRegistryDtoIo();
        PgpKeyStateRegistryDto pgpKeyStateRegistryDto = this.createPgpKeyStateRegistryDto();
        zout.putNextEntry(new ZipEntry(PAYLOAD_ENTRY_NAME));
        pgpKeyStateRegistryDtoIo.serialize(pgpKeyStateRegistryDto, zout);
        zout.closeEntry();
    }

    private PgpKeyStateRegistryDto createPgpKeyStateRegistryDto() {
        PgpKeyStateRegistryDto pgpKeyStateRegistryDto = new PgpKeyStateRegistryDto();
        for (PgpKeyStateDto pgpKeyStateDto : this.pgpKeyId2PgpKeyStateDto.values()) {
            pgpKeyStateRegistryDto.getPgpKeyStateDtos().add(pgpKeyStateDto);
        }
        pgpKeyStateRegistryDto.setVersion(this.version);
        return pgpKeyStateRegistryDto;
    }

    @Override
    protected void mergeFrom(ZipInputStream zin, ZipEntry zipEntry) {
        if (PAYLOAD_ENTRY_NAME.equals(zipEntry.getName())) {
            PgpKeyStateRegistryDtoIo pgpKeyStateRegistryDtoIo = new PgpKeyStateRegistryDtoIo();
            PgpKeyStateRegistryDto pgpKeyStateRegistryDto = (PgpKeyStateRegistryDto)pgpKeyStateRegistryDtoIo.deserialize(zin);
            this.mergeFrom(pgpKeyStateRegistryDto);
        }
    }

    protected synchronized void syncWithPgp() {
        PgpKeyId pgpKeyId;
        logger.info("syncWithPgp: entered.");
        long startTimestamp = System.currentTimeMillis();
        this.needUpdateTrustDb = false;
        for (PgpKeyStateDto pgpKeyStateDto : this.pgpKeyId2PgpKeyStateDto.values()) {
            pgpKeyId = Objects.requireNonNull(pgpKeyStateDto.getPgpKeyId(), "pgpKeyStateDto.pgpKeyId");
            PgpKey pgpKey = this.pgp.getPgpKey(pgpKeyId);
            if (pgpKey == null || !this.isDefaults(pgpKey)) continue;
            if (pgpKeyStateDto.isDisabled()) {
                this.needUpdateTrustDb = true;
                this.pgp.setDisabled(pgpKey, true);
            }
            if (pgpKeyStateDto.getOwnerTrust() == PgpOwnerTrust.UNSPECIFIED) continue;
            this.needUpdateTrustDb = true;
            this.pgp.setOwnerTrust(pgpKey, pgpKeyStateDto.getOwnerTrust());
        }
        for (PgpKey pgpKey : this.pgp.getMasterKeys()) {
            pgpKeyId = pgpKey.getPgpKeyId();
            PgpKeyStateDto pgpKeyStateDto = this.pgpKeyId2PgpKeyStateDto.get(pgpKeyId);
            if (pgpKeyStateDto == null) {
                if (this.isDefaults(pgpKey)) continue;
                pgpKeyStateDto = this.createPgpKeyStateDto(pgpKey);
                this.pgpKeyId2PgpKeyStateDto.put(pgpKeyId, pgpKeyStateDto);
                this.markDirty();
                continue;
            }
            if (!this.isModified(pgpKey, pgpKeyStateDto)) continue;
            this.updatePgpKeyStateDto(pgpKey, pgpKeyStateDto);
            this.markDirty();
        }
        if (this.needUpdateTrustDb) {
            this.pgp.updateTrustDb();
        }
        this.writeIfNeeded();
        logger.info("syncWithPgp: leaving (took {} ms).", (Object)(System.currentTimeMillis() - startTimestamp));
    }

    private PgpKeyStateDto createPgpKeyStateDto(PgpKey pgpKey) {
        Objects.requireNonNull(pgpKey, "pgpKey");
        PgpKeyStateDto pgpKeyStateDto = new PgpKeyStateDto();
        pgpKeyStateDto.setPgpKeyId(pgpKey.getPgpKeyId());
        pgpKeyStateDto.setCreated(new Date());
        this.updatePgpKeyStateDto(pgpKey, pgpKeyStateDto);
        return pgpKeyStateDto;
    }

    private void updatePgpKeyStateDto(PgpKey pgpKey, PgpKeyStateDto pgpKeyStateDto) {
        Objects.requireNonNull(pgpKey, "pgpKey");
        Objects.requireNonNull(pgpKeyStateDto, "pgpKeyStateDto");
        pgpKeyStateDto.setChanged(new Date());
        pgpKeyStateDto.setDisabled(pgpKey.isDisabled());
        pgpKeyStateDto.setOwnerTrust(this.pgp.getOwnerTrust(pgpKey));
    }

    private boolean isDefaults(PgpKey pgpKey) {
        boolean enabled = !pgpKey.isDisabled();
        PgpOwnerTrust ownerTrust = this.pgp.getOwnerTrust(pgpKey);
        return enabled && ownerTrust == PgpOwnerTrust.UNSPECIFIED;
    }

    private boolean isModified(PgpKey pgpKey, PgpKeyStateDto pgpKeyStateDto) {
        Objects.requireNonNull(pgpKey, "pgpKey");
        Objects.requireNonNull(pgpKeyStateDto, "pgpKeyStateDto");
        return pgpKeyStateDto.isDisabled() != pgpKey.isDisabled() || pgpKeyStateDto.getOwnerTrust() != this.pgp.getOwnerTrust(pgpKey);
    }

    protected synchronized void mergeFrom(PgpKeyStateRegistryDto pgpKeyStateRegistryDto) {
        Objects.requireNonNull(pgpKeyStateRegistryDto, "pgpKeyStateRegistryDto");
        this.needUpdateTrustDb = false;
        for (PgpKeyStateDto inPgpKeyStateDto : pgpKeyStateRegistryDto.getPgpKeyStateDtos()) {
            PgpKeyId pgpKeyId = Objects.requireNonNull(inPgpKeyStateDto.getPgpKeyId(), "inPgpKeyStateDto.pgpKeyId");
            PgpKey pgpKey = this.pgp.getPgpKey(pgpKeyId);
            PgpKeyStateDto myPgpKeyStateDto = this.pgpKeyId2PgpKeyStateDto.get(pgpKeyId);
            if (myPgpKeyStateDto != null && myPgpKeyStateDto.getChanged().compareTo(inPgpKeyStateDto.getChanged()) >= 0) continue;
            myPgpKeyStateDto = inPgpKeyStateDto;
            this.pgpKeyId2PgpKeyStateDto.put(pgpKeyId, myPgpKeyStateDto);
            if (pgpKey != null) {
                this.updatePgp(pgpKey, myPgpKeyStateDto);
            }
            this.markDirty();
        }
        if (this.needUpdateTrustDb) {
            this.pgp.updateTrustDb();
        }
        this.writeIfNeeded();
    }

    private void updatePgp(PgpKey pgpKey, PgpKeyStateDto pgpKeyStateDto) {
        Objects.requireNonNull(pgpKey, "pgpKey");
        Objects.requireNonNull(pgpKeyStateDto, "pgpKeyStateDto");
        if (pgpKey.isDisabled() != pgpKeyStateDto.isDisabled()) {
            this.needUpdateTrustDb = true;
            this.pgp.setDisabled(pgpKey, pgpKeyStateDto.isDisabled());
        }
        if (pgpKeyStateDto.getOwnerTrust() != PgpOwnerTrust.UNSPECIFIED) {
            this.needUpdateTrustDb = true;
            this.pgp.setOwnerTrust(pgpKey, pgpKeyStateDto.getOwnerTrust());
        }
    }

    public Uid getVersion() {
        return this.version;
    }

    private static final class Holder {
        public static final PgpKeyStateRegistryImpl instance = new PgpKeyStateRegistryImpl();

        private Holder() {
        }
    }
}

