/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.openpgp.wot.internal.PgpUserIdTrust;
import org.bouncycastle.openpgp.wot.internal.Util;
import org.bouncycastle.openpgp.wot.key.PgpKey;
import org.bouncycastle.openpgp.wot.key.PgpKeyFingerprint;
import org.bouncycastle.openpgp.wot.key.PgpUserId;
import org.bouncycastle.openpgp.wot.key.PgpUserIdNameHash;

class PgpKeyTrust {
    private final PgpKey pgpKey;
    private final Map<PgpUserIdNameHash, PgpUserIdTrust> nameHash2UserIdTrust = new HashMap<PgpUserIdNameHash, PgpUserIdTrust>();

    public PgpKeyTrust(PgpKey pgpKey) {
        this.pgpKey = Util.assertNotNull(pgpKey, "pgpKey");
    }

    public PgpKey getPgpKey() {
        return this.pgpKey;
    }

    public PgpKeyFingerprint getPgpKeyFingerprint() {
        return this.pgpKey.getPgpKeyFingerprint();
    }

    public PgpUserIdTrust getPgpUserIdTrust(PgpUserId pgpUserId) {
        Util.assertNotNull(pgpUserId, "pgpUserId");
        PgpUserIdTrust pgpUserIdTrust = this.nameHash2UserIdTrust.get(pgpUserId.getNameHash());
        if (pgpUserIdTrust == null) {
            pgpUserIdTrust = new PgpUserIdTrust(this, pgpUserId);
            this.nameHash2UserIdTrust.put(pgpUserId.getNameHash(), pgpUserIdTrust);
        }
        return pgpUserIdTrust;
    }

    public Collection<PgpUserIdTrust> getPgpUserIdTrusts() {
        return Collections.unmodifiableCollection(this.nameHash2UserIdTrust.values());
    }
}

