/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.core.auth;

import co.codewizards.cloudstore.core.auth.AuthToken;
import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class AuthTokenIO {
    public byte[] serialise(AuthToken authToken) {
        Objects.requireNonNull(authToken, "authToken");
        try {
            JAXBContext context = this.createContext();
            Marshaller marshaller = context.createMarshaller();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            marshaller.marshal((Object)authToken, (OutputStream)os);
            return os.toByteArray();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public AuthToken deserialise(byte[] authTokenData) {
        Objects.requireNonNull(authTokenData, "authTokenData");
        try {
            JAXBContext context = this.createContext();
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object object = unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(authTokenData));
            return (AuthToken)object;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private JAXBContext createContext() throws JAXBException {
        return JAXBContext.newInstance((Class[])new Class[]{AuthToken.class});
    }
}

