/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.crypto;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.crypto.CipherTransformation;
import org.subshare.core.crypto.CryptoConfigUtil;
import org.subshare.crypto.CryptoRegistry;
import org.subshare.crypto.SecretKeyGenerator;

@Deprecated
public class KeyFactory {
    private static final Logger logger = LoggerFactory.getLogger(KeyFactory.class);
    public static final SecureRandom secureRandom = new SecureRandom();

    public static KeyFactory getInstance() {
        return Holder.instance;
    }

    private KeyFactory() {
    }

    public KeyParameter createSymmetricKey() {
        SecretKeyGenerator secretKeyGenerator;
        CipherTransformation symmetricCipherTransformation = CryptoConfigUtil.getSymmetricCipherTransformation();
        String engine = CryptoRegistry.splitTransformation((String)symmetricCipherTransformation.getTransformation())[0];
        try {
            secretKeyGenerator = CryptoRegistry.getInstance().createSecretKeyGenerator(engine, true);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        KeyParameter key = secretKeyGenerator.generateKey();
        return key;
    }

    public AsymmetricCipherKeyPair createAsymmetricKeyPair(KeyGenerationParameters keyGenerationParameters) {
        AsymmetricCipherKeyPairGenerator keyPairGenerator;
        long startTimestamp = System.currentTimeMillis();
        CipherTransformation asymmetricCipherTransformation = CryptoConfigUtil.getAsymmetricCipherTransformation();
        String engine = CryptoRegistry.splitTransformation((String)asymmetricCipherTransformation.getTransformation())[0];
        if (Boolean.parseBoolean(System.getProperty("testEnvironment"))) {
            keyGenerationParameters = new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), secureRandom, 1024, 12);
        }
        try {
            keyPairGenerator = CryptoRegistry.getInstance().createKeyPairGenerator(engine, keyGenerationParameters == null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        if (keyGenerationParameters != null) {
            keyPairGenerator.init(keyGenerationParameters);
        }
        AsymmetricCipherKeyPair keyPair = keyPairGenerator.generateKeyPair();
        logger.info("Creating asymmetric key pair with {} took {} ms.", (Object)(keyGenerationParameters == null ? "defaults" : KeyFactory.toString(keyGenerationParameters)), (Object)(System.currentTimeMillis() - startTimestamp));
        return keyPair;
    }

    private static final String toString(KeyGenerationParameters keyGenerationParameters) {
        if (keyGenerationParameters instanceof RSAKeyGenerationParameters) {
            RSAKeyGenerationParameters kgp = (RSAKeyGenerationParameters)keyGenerationParameters;
            return String.format("publicExponent='%s' strength='%s' certainty='%s'", kgp.getPublicExponent(), kgp.getStrength(), kgp.getCertainty());
        }
        return String.valueOf(keyGenerationParameters);
    }

    public AsymmetricCipherKeyPair createAsymmetricKeyPair() {
        return this.createAsymmetricKeyPair(null);
    }

    private static final class Holder {
        static final KeyFactory instance = new KeyFactory();

        private Holder() {
        }
    }
}

