/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.CookieParam;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.glassfish.jersey.server.ParamException;
import org.glassfish.jersey.server.internal.inject.AbstractContainerRequestValueFactory;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.ExtractorException;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;

@Singleton
final class CookieParamValueFactoryProvider
extends AbstractValueFactoryProvider {
    @Inject
    public CookieParamValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator injector) {
        super(mpep, injector, Parameter.Source.COOKIE);
    }

    public AbstractContainerRequestValueFactory<?> createValueFactory(Parameter parameter) {
        String parameterName = parameter.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        if (parameter.getRawType() == Cookie.class) {
            return new CookieTypeParamValueFactory(parameterName);
        }
        MultivaluedParameterExtractor<?> e = this.get(parameter);
        if (e == null) {
            return null;
        }
        return new CookieParamValueFactory(e);
    }

    private static final class CookieTypeParamValueFactory
    extends AbstractContainerRequestValueFactory<Cookie> {
        private final String name;

        CookieTypeParamValueFactory(String name) {
            this.name = name;
        }

        public Cookie provide() {
            return this.getContainerRequest().getCookies().get(this.name);
        }
    }

    private static final class CookieParamValueFactory
    extends AbstractContainerRequestValueFactory<Object> {
        private final MultivaluedParameterExtractor<?> extractor;

        CookieParamValueFactory(MultivaluedParameterExtractor<?> extractor) {
            this.extractor = extractor;
        }

        public Object provide() {
            MultivaluedStringMap cookies = new MultivaluedStringMap();
            for (Map.Entry<String, Cookie> e : this.getContainerRequest().getCookies().entrySet()) {
                cookies.putSingle((Object)e.getKey(), (Object)e.getValue().getValue());
            }
            try {
                return this.extractor.extract((MultivaluedMap<String, String>)cookies);
            }
            catch (ExtractorException ex) {
                throw new ParamException.CookieParamException(ex.getCause(), this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }

    @Singleton
    static final class InjectionResolver
    extends ParamInjectionResolver<CookieParam> {
        public InjectionResolver() {
            super(CookieParamValueFactoryProvider.class);
        }
    }
}

