/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.locker.transport;

import co.codewizards.cloudstore.core.util.UrlUtil;
import java.net.URL;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.locker.LockerContent;
import org.subshare.core.locker.transport.LockerTransport;
import org.subshare.core.locker.transport.LockerTransportFactory;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpRegistry;

public abstract class AbstractLockerTransport
implements LockerTransport {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLockerTransport.class);
    private static final String SLASH = "/";
    private LockerTransportFactory lockerTransportFactory;
    private URL url;
    private LockerContent lockerContent;
    private PgpKey pgpKey;
    private volatile Throwable lockerTransportCreatedStackTraceException = new Exception("lockerTransportCreatedStackTraceException").fillInStackTrace();

    @Override
    public LockerTransportFactory getLockerTransportFactory() {
        return this.lockerTransportFactory;
    }

    @Override
    public void setLockerTransportFactory(LockerTransportFactory lockerTransportFactory) {
        this.lockerTransportFactory = Objects.requireNonNull(lockerTransportFactory, "lockerTransportFactory");
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(URL url) {
        url = UrlUtil.canonicalizeURL((URL)url);
        URL rr = this.url;
        if (rr != null && !rr.equals(url)) {
            throw new IllegalStateException("Cannot re-assign url!");
        }
        this.url = url;
    }

    @Override
    public LockerContent getLockerContent() {
        return this.lockerContent;
    }

    protected LockerContent getLockerContentOrFail() {
        LockerContent lockerContent = this.getLockerContent();
        Objects.requireNonNull(lockerContent, "lockerContent");
        return lockerContent;
    }

    @Override
    public void setLockerContent(LockerContent lockerContent) {
        this.lockerContent = lockerContent;
    }

    protected Pgp getPgp() {
        Pgp pgp = PgpRegistry.getInstance().getPgpOrFail();
        return pgp;
    }

    @Override
    public PgpKey getPgpKey() {
        return this.pgpKey;
    }

    protected PgpKey getPgpKeyOrFail() {
        PgpKey pgpKey = this.getPgpKey();
        Objects.requireNonNull(pgpKey, "pgpKey");
        return pgpKey;
    }

    @Override
    public void setPgpKey(PgpKey pgpKey) {
        this.pgpKey = pgpKey;
    }

    protected void finalize() throws Throwable {
        if (this.lockerTransportCreatedStackTraceException != null) {
            logger.warn("finalize: Detected forgotten close() invocation!", this.lockerTransportCreatedStackTraceException);
        }
        super.finalize();
    }

    @Override
    public void close() {
        this.lockerTransportCreatedStackTraceException = null;
    }
}

