/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.security.SecureRandom;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPUtil;

public abstract class PBESecretKeyEncryptor {
    protected int encAlgorithm;
    protected char[] passPhrase;
    protected PGPDigestCalculator s2kDigestCalculator;
    protected int s2kCount;
    protected S2K s2k;
    protected SecureRandom random;

    protected PBESecretKeyEncryptor(int encAlgorithm, PGPDigestCalculator s2kDigestCalculator, SecureRandom random, char[] passPhrase) {
        this(encAlgorithm, s2kDigestCalculator, 96, random, passPhrase);
    }

    protected PBESecretKeyEncryptor(int encAlgorithm, PGPDigestCalculator s2kDigestCalculator, int s2kCount, SecureRandom random, char[] passPhrase) {
        this.encAlgorithm = encAlgorithm;
        this.passPhrase = passPhrase;
        this.random = random;
        this.s2kDigestCalculator = s2kDigestCalculator;
        if (s2kCount < 0 || s2kCount > 255) {
            throw new IllegalArgumentException("s2kCount value outside of range 0 to 255.");
        }
        this.s2kCount = s2kCount;
    }

    public int getAlgorithm() {
        return this.encAlgorithm;
    }

    public int getHashAlgorithm() {
        if (this.s2kDigestCalculator != null) {
            return this.s2kDigestCalculator.getAlgorithm();
        }
        return -1;
    }

    public byte[] getKey() throws PGPException {
        return PGPUtil.makeKeyFromPassPhrase(this.s2kDigestCalculator, this.encAlgorithm, this.s2k, this.passPhrase);
    }

    public S2K getS2K() {
        return this.s2k;
    }

    public byte[] encryptKeyData(byte[] keyData, int keyOff, int keyLen) throws PGPException {
        if (this.s2k == null) {
            byte[] iv = new byte[8];
            this.random.nextBytes(iv);
            this.s2k = new S2K(this.s2kDigestCalculator.getAlgorithm(), iv, this.s2kCount);
        }
        return this.encryptKeyData(this.getKey(), keyData, keyOff, keyLen);
    }

    public abstract byte[] encryptKeyData(byte[] var1, byte[] var2, int var3, int var4) throws PGPException;

    public byte[] encryptKeyData(byte[] key, byte[] iv, byte[] keyData, int keyOff, int keyLen) throws PGPException {
        throw new PGPException("encryption of version 3 keys not supported.");
    }

    public abstract byte[] getCipherIV();
}

