/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.Entity;
import co.codewizards.cloudstore.local.persistence.FetchPlanBackup;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.dto.CurrentHistoCryptoRepoFileDto;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.CurrentHistoCryptoRepoFile;

public class CurrentHistoCryptoRepoFileDao
extends Dao<CurrentHistoCryptoRepoFile, CurrentHistoCryptoRepoFileDao> {
    private static final Logger logger = LoggerFactory.getLogger(CurrentHistoCryptoRepoFileDao.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CurrentHistoCryptoRepoFile> getCurrentHistoCryptoRepoFilesChangedAfterExclLastSyncFromRepositoryId(long localRevision, UUID exclLastSyncFromRepositoryId) {
        Objects.requireNonNull(exclLastSyncFromRepositoryId, "exclLastSyncFromRepositoryId");
        PersistenceManager pm = this.pm();
        FetchPlanBackup fetchPlanBackup = FetchPlanBackup.createFrom((PersistenceManager)pm);
        Query query = pm.newNamedQuery(this.getEntityClass(), "getCurrentHistoCryptoRepoFilesChangedAfter_localRevision_exclLastSyncFromRepositoryId");
        try {
            this.clearFetchGroups();
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.execute((Object)localRevision, (Object)exclLastSyncFromRepositoryId.toString());
            logger.debug("getCurrentHistoCryptoRepoFilesChangedAfterExclLastSyncFromRepositoryId: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            fetchPlanBackup.restore(pm);
            startTimestamp = System.currentTimeMillis();
            result = this.load(result);
            logger.debug("getCurrentHistoCryptoRepoFilesChangedAfterExclLastSyncFromRepositoryId: Loading result-set with {} elements took {} ms.", (Object)result.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = result;
            return collection;
        }
        finally {
            query.closeAll();
            fetchPlanBackup.restore(pm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CurrentHistoCryptoRepoFileDto> getCurrentHistoCryptoRepoFileDtosChangedAfterExclLastSyncFromRepositoryId(long localRevision, UUID exclLastSyncFromRepositoryId) {
        Objects.requireNonNull(exclLastSyncFromRepositoryId, "exclLastSyncFromRepositoryId");
        PersistenceManager pm = this.pm();
        FetchPlanBackup fetchPlanBackup = FetchPlanBackup.createFrom((PersistenceManager)pm);
        Query query = pm.newNamedQuery(this.getEntityClass(), "getCurrentHistoCryptoRepoFilesChangedAfter_localRevision_exclLastSyncFromRepositoryId");
        try {
            this.clearFetchGroups();
            long startTimestamp = System.currentTimeMillis();
            Collection result = (Collection)query.execute((Object)localRevision, (Object)exclLastSyncFromRepositoryId.toString());
            logger.debug("getCurrentHistoCryptoRepoFileDtosChangedAfterExclLastSyncFromRepositoryId: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            fetchPlanBackup.restore(pm);
            startTimestamp = System.currentTimeMillis();
            List<CurrentHistoCryptoRepoFileDto> resultDtos = this.loadDtos(result);
            logger.debug("getCurrentHistoCryptoRepoFileDtosChangedAfterExclLastSyncFromRepositoryId: Loading result-set with {} elements took {} ms.", (Object)resultDtos.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            List<CurrentHistoCryptoRepoFileDto> list = resultDtos;
            return list;
        }
        finally {
            query.closeAll();
            fetchPlanBackup.restore(pm);
        }
    }

    protected List<CurrentHistoCryptoRepoFileDto> loadDtos(Collection<CurrentHistoCryptoRepoFile> entities) {
        return super.loadDtos(entities, CurrentHistoCryptoRepoFileDto.class, "this.cryptoRepoFile.cryptoRepoFileId, this.histoCryptoRepoFile.histoCryptoRepoFileId, this.signature");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CurrentHistoCryptoRepoFile getCurrentHistoCryptoRepoFile(CryptoRepoFile cryptoRepoFile) {
        Objects.requireNonNull(cryptoRepoFile, "cryptoRepoFile");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getCurrentHistoCryptoRepoFile_cryptoRepoFile");
        try {
            CurrentHistoCryptoRepoFile result;
            CurrentHistoCryptoRepoFile currentHistoCryptoRepoFile = result = (CurrentHistoCryptoRepoFile)((Object)query.execute((Object)cryptoRepoFile));
            return currentHistoCryptoRepoFile;
        }
        finally {
            query.closeAll();
        }
    }

    public void deletePersistent(CurrentHistoCryptoRepoFile entity) {
        super.deletePersistent((Entity)entity);
    }

    public void deletePersistentAll(Collection<? extends CurrentHistoCryptoRepoFile> entities) {
        super.deletePersistentAll(entities);
    }
}

