/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.server;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import co.codewizards.cloudstore.core.appid.AppIdRegistry;
import co.codewizards.cloudstore.core.auth.BouncyCastleRegistrationUtil;
import co.codewizards.cloudstore.core.config.ConfigDir;
import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.util.DebugUtil;
import co.codewizards.cloudstore.core.util.DerbyUtil;
import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.core.util.MainArgsUtil;
import co.codewizards.cloudstore.core.util.Util;
import co.codewizards.cloudstore.ls.server.LocalServer;
import co.codewizards.cloudstore.rest.server.CloudStoreRest;
import co.codewizards.cloudstore.server.CloudStoreUpdaterTimer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Servlet;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudStoreServer
implements Runnable {
    public static final String CONFIG_KEY_SECURE_PORT = "server.securePort";
    private static final Logger logger = LoggerFactory.getLogger(CloudStoreServer.class);
    private static Class<? extends CloudStoreServer> cloudStoreServerClass = CloudStoreServer.class;
    private static final int DEFAULT_SECURE_PORT = 8443;
    private static final String CERTIFICATE_ALIAS = "CloudStoreServer";
    private static final String CERTIFICATE_COMMON_NAME = "CloudStoreServer";
    private static final String KEY_STORE_PASSWORD_STRING = "CloudStore-key-store";
    private static final char[] KEY_STORE_PASSWORD_CHAR_ARRAY = "CloudStore-key-store".toCharArray();
    private static final String KEY_PASSWORD_STRING = "CloudStore-private-key";
    private static final char[] KEY_PASSWORD_CHAR_ARRAY = "CloudStore-private-key".toCharArray();
    private File keyStoreFile;
    private final SecureRandom random = new SecureRandom();
    private int securePort;
    private final AtomicBoolean running = new AtomicBoolean();
    private Server server;
    private CloudStoreUpdaterTimer updaterTimer;

    public static void main(String[] args) throws Exception {
        args = MainArgsUtil.extractAndApplySystemPropertiesReturnOthers((String[])args);
        CloudStoreServer.initLogging();
        try {
            CloudStoreServer.createCloudStoreServer(args).run();
        }
        catch (Throwable x) {
            logger.error(x.toString(), x);
            System.exit(999);
        }
    }

    public CloudStoreServer(String ... args) {
        BouncyCastleRegistrationUtil.registerBouncyCastleIfNeeded();
    }

    protected static Constructor<? extends CloudStoreServer> getCloudStoreServerConstructor() throws NoSuchMethodException, SecurityException {
        Class<? extends CloudStoreServer> clazz = CloudStoreServer.getCloudStoreServerClass();
        Constructor<? extends CloudStoreServer> constructor = clazz.getConstructor(String[].class);
        return constructor;
    }

    protected static CloudStoreServer createCloudStoreServer(String[] args) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<? extends CloudStoreServer> constructor = CloudStoreServer.getCloudStoreServerConstructor();
        CloudStoreServer cloudStoreServer = constructor.newInstance(new Object[]{args});
        return cloudStoreServer;
    }

    protected static Class<? extends CloudStoreServer> getCloudStoreServerClass() {
        return cloudStoreServerClass;
    }

    protected static void setCloudStoreServerClass(Class<? extends CloudStoreServer> cloudStoreServerClass) {
        Objects.requireNonNull(cloudStoreServerClass, "cloudStoreServerClass");
        CloudStoreServer.cloudStoreServerClass = cloudStoreServerClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("Server is already running!");
        }
        LocalServer localServer = null;
        try {
            this.initKeyStore();
            CloudStoreServer cloudStoreServer = this;
            synchronized (cloudStoreServer) {
                localServer = this.createLocalServer();
                if (!localServer.start()) {
                    localServer = null;
                }
                this.server = this.createServer();
                this.server.start();
                this.updaterTimer = this.createUpdaterTimer();
                this.updaterTimer.start();
            }
            this.server.join();
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
        finally {
            CloudStoreServer cloudStoreServer = this;
            synchronized (cloudStoreServer) {
                if (localServer != null) {
                    try {
                        localServer.stop();
                    }
                    catch (Exception x) {
                        logger.warn("localServer.stop() failed: " + x, (Throwable)x);
                    }
                    localServer = null;
                }
                this.server = null;
            }
            this.running.set(false);
        }
    }

    protected CloudStoreUpdaterTimer createUpdaterTimer() {
        return new CloudStoreUpdaterTimer();
    }

    protected LocalServer createLocalServer() {
        return new LocalServer();
    }

    public synchronized void stop() {
        if (this.updaterTimer != null) {
            this.updaterTimer.stop();
        }
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
    }

    public synchronized File getKeyStoreFile() {
        if (this.keyStoreFile == null) {
            File sslServer = OioFileFactory.createFile((File)ConfigDir.getInstance().getFile(), (String[])new String[]{"ssl.server"});
            if (!sslServer.isDirectory()) {
                sslServer.mkdirs();
            }
            if (!sslServer.isDirectory()) {
                throw new IllegalStateException("Could not create directory: " + sslServer);
            }
            this.keyStoreFile = OioFileFactory.createFile((File)sslServer, (String[])new String[]{"keystore"});
        }
        return this.keyStoreFile;
    }

    public synchronized void setKeyStoreFile(File keyStoreFile) {
        this.assertNotRunning();
        this.keyStoreFile = keyStoreFile;
    }

    public synchronized int getSecurePort() {
        if (this.securePort <= 0) {
            this.securePort = ConfigImpl.getInstance().getPropertyAsInt(CONFIG_KEY_SECURE_PORT, 8443);
            if (this.securePort < 1 || this.securePort > 65535) {
                logger.warn("Config key '{}' is set to the value '{}' which is out of range for a port number. Falling back to default port {}.", new Object[]{CONFIG_KEY_SECURE_PORT, this.securePort, 8443});
                this.securePort = 8443;
            }
        }
        return this.securePort;
    }

    public synchronized void setSecurePort(int securePort) {
        this.assertNotRunning();
        this.securePort = securePort;
    }

    private void assertNotRunning() {
        if (this.running.get()) {
            throw new IllegalStateException("Server is already running.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initKeyStore() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, InvalidKeyException, SecurityException, SignatureException, NoSuchProviderException, UnrecoverableEntryException {
        if (!this.getKeyStoreFile().exists()) {
            logger.info("initKeyStore: keyStoreFile='{}' does not exist!", (Object)this.getKeyStoreFile());
            logger.info("initKeyStore: Creating RSA key pair (this might take a while)...");
            System.out.println("**********************************************************************");
            System.out.println("There is no key, yet. Creating a new RSA key pair, now. This might");
            System.out.println("take a while (a few seconds up to a few minutes). Please be patient!");
            System.out.println("**********************************************************************");
            long keyGenStartTimestamp = System.currentTimeMillis();
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null, KEY_STORE_PASSWORD_CHAR_ARRAY);
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(4096, this.random);
            KeyPair pair = keyGen.generateKeyPair();
            X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
            long serial = new SecureRandom().nextLong();
            v3CertGen.setSerialNumber(BigInteger.valueOf(serial).abs());
            v3CertGen.setIssuerDN((X509Name)new X509Principal("CN=CloudStoreServer, OU=None, O=None, C=None"));
            v3CertGen.setNotBefore(new Date(System.currentTimeMillis() - 259200000L));
            v3CertGen.setNotAfter(new Date(System.currentTimeMillis() + 315360000000L));
            v3CertGen.setSubjectDN((X509Name)new X509Principal("CN=CloudStoreServer, OU=None, O=None, C=None"));
            v3CertGen.setPublicKey(pair.getPublic());
            v3CertGen.setSignatureAlgorithm("SHA1WithRSAEncryption");
            X509Certificate pkCertificate = v3CertGen.generateX509Certificate(pair.getPrivate());
            KeyStore.PrivateKeyEntry entry = new KeyStore.PrivateKeyEntry(pair.getPrivate(), new Certificate[]{pkCertificate});
            ks.setEntry("CloudStoreServer", entry, new KeyStore.PasswordProtection(KEY_PASSWORD_CHAR_ARRAY));
            try (OutputStream fos = StreamUtil.castStream((IOutputStream)this.getKeyStoreFile().createOutputStream());){
                ks.store(fos, KEY_STORE_PASSWORD_CHAR_ARRAY);
            }
            long keyGenDuration = System.currentTimeMillis() - keyGenStartTimestamp;
            logger.info("initKeyStore: Creating RSA key pair took {} ms.", (Object)keyGenDuration);
            System.out.println(String.format("Generating a new RSA key pair took %s ms.", keyGenDuration));
        }
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream fis = StreamUtil.castStream((IInputStream)this.getKeyStoreFile().createInputStream());){
            ks.load(fis, KEY_STORE_PASSWORD_CHAR_ARRAY);
        }
        X509Certificate certificate = (X509Certificate)ks.getCertificate("CloudStoreServer");
        String certificateSha1 = HashUtil.sha1ForHuman((byte[])certificate.getEncoded());
        System.out.println("**********************************************************************");
        System.out.println("Server certificate fingerprint (SHA1):");
        System.out.println();
        System.out.println("    " + certificateSha1);
        System.out.println();
        System.out.println("Use this fingerprint to verify on the client-side, whether you're");
        System.out.println("really talking to this server. If the client shows you a different");
        System.out.println("value, someone is tampering with your connection!");
        System.out.println();
        System.out.println("Please keep this fingerprint at a safe place. You'll need it whenever");
        System.out.println("one of your clients connects to this server for the first time.");
        System.out.println("**********************************************************************");
        logger.info("initKeyStore: RSA fingerprint (SHA1): {}", (Object)certificateSha1);
    }

    protected Server createServer() {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(500);
        Server server = new Server((ThreadPool)threadPool);
        server.addBean((Object)new ScheduledExecutorScheduler());
        HttpConfiguration http_config = this.createHttpConfigurationForHTTP();
        server.setHandler((Handler)this.createServletContextHandler());
        server.setDumpAfterStart(false);
        server.setDumpBeforeStop(false);
        server.setStopAtShutdown(true);
        HttpConfiguration https_config = this.createHttpConfigurationForHTTPS(http_config);
        server.addConnector((Connector)this.createServerConnectorForHTTPS(server, https_config));
        return server;
    }

    private HttpConfiguration createHttpConfigurationForHTTP() {
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setSecureScheme("https");
        http_config.setSecurePort(this.getSecurePort());
        http_config.setOutputBufferSize(32768);
        http_config.setRequestHeaderSize(8192);
        http_config.setResponseHeaderSize(8192);
        http_config.setSendServerVersion(true);
        http_config.setSendDateHeader(false);
        return http_config;
    }

    private HttpConfiguration createHttpConfigurationForHTTPS(HttpConfiguration httpConfigurationForHTTP) {
        HttpConfiguration https_config = new HttpConfiguration(httpConfigurationForHTTP);
        https_config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        return https_config;
    }

    private ServletContextHandler createServletContextHandler() {
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        ServletContainer servletContainer = new ServletContainer(Objects.requireNonNull(this.createResourceConfig(), "createResourceConfig()"));
        context.addServlet(new ServletHolder((Servlet)servletContainer), "/*");
        return context;
    }

    protected ResourceConfig createResourceConfig() {
        return new CloudStoreRest();
    }

    private ServerConnector createServerConnectorForHTTPS(Server server, HttpConfiguration httpConfigurationForHTTPS) {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(this.getKeyStoreFile().getPath());
        sslContextFactory.setKeyStorePassword(KEY_STORE_PASSWORD_STRING);
        sslContextFactory.setKeyManagerPassword(KEY_PASSWORD_STRING);
        sslContextFactory.setTrustStorePath(this.getKeyStoreFile().getPath());
        sslContextFactory.setTrustStorePassword(KEY_STORE_PASSWORD_STRING);
        sslContextFactory.setExcludeCipherSuites(new String[]{".*RC4.*", ".*DES.*"});
        ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpConfigurationForHTTPS)});
        sslConnector.setPort(this.getSecurePort());
        return sslConnector;
    }

    private static void initLogging() throws IOException, JoranException {
        File logDir = ConfigDir.getInstance().getLogDir();
        DerbyUtil.setLogFile((File)OioFileFactory.createFile((File)logDir, (String[])new String[]{"derby.log"}));
        String logbackXmlName = "logback.server.xml";
        File logbackXmlFile = OioFileFactory.createFile((File)ConfigDir.getInstance().getFile(), (String[])new String[]{"logback.server.xml"});
        if (!logbackXmlFile.exists()) {
            AppIdRegistry.getInstance().copyResourceResolvingAppId(CloudStoreServer.class, "logback.server.xml", logbackXmlFile);
        }
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            configurator.doConfigure(logbackXmlFile.getIoFile());
        }
        catch (JoranException je) {
            Util.doNothing();
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
        DebugUtil.logSystemProperties();
    }
}

