/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.crypto.internal.symmetric;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.CTSBlockCipher;
import org.bouncycastle.crypto.modes.OFBBlockCipher;
import org.subshare.crypto.AbstractCipher;
import org.subshare.crypto.CipherOperationMode;
import org.subshare.crypto.CryptoRegistry;

public class BufferedBlockCipherImpl
extends AbstractCipher {
    private final BufferedBlockCipher delegate;
    private int ivSize = -1;

    public BufferedBlockCipherImpl(String transformation, BufferedBlockCipher delegate) {
        super(transformation);
        this.delegate = delegate;
    }

    @Override
    public void _init(CipherOperationMode mode, CipherParameters parameters) throws IllegalArgumentException {
        this.delegate.init(CipherOperationMode.ENCRYPT == mode, parameters);
    }

    @Override
    public int getInputBlockSize() {
        return this.delegate.getBlockSize();
    }

    @Override
    public int getOutputBlockSize() {
        return this.delegate.getBlockSize();
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }

    @Override
    public int getUpdateOutputSize(int len) {
        return this.delegate.getUpdateOutputSize(len);
    }

    @Override
    public int getOutputSize(int length) {
        return this.delegate.getOutputSize(length);
    }

    @Override
    public int update(byte in, byte[] out, int outOff) throws DataLengthException, IllegalStateException, CryptoException {
        return this.delegate.processByte(in, out, outOff);
    }

    @Override
    public int update(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException, IllegalStateException, CryptoException {
        return this.delegate.processBytes(in, inOff, len, out, outOff);
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException, CryptoException {
        return this.delegate.doFinal(out, outOff);
    }

    @Override
    public int getIVSize() {
        if (this.ivSize < 0) {
            BlockCipher underlyingCipher;
            CTSBlockCipher cts;
            String mode = CryptoRegistry.splitTransformation(this.getTransformation())[1];
            this.ivSize = "".equals(mode) || "ECB".equals(mode) ? 0 : (this.delegate instanceof CTSBlockCipher ? ((cts = (CTSBlockCipher)this.delegate).getUnderlyingCipher() instanceof CBCBlockCipher ? cts.getUnderlyingCipher().getBlockSize() : 0) : ((underlyingCipher = this.delegate.getUnderlyingCipher()) instanceof CFBBlockCipher ? ((CFBBlockCipher)underlyingCipher).getUnderlyingCipher().getBlockSize() : (underlyingCipher instanceof OFBBlockCipher ? ((OFBBlockCipher)underlyingCipher).getUnderlyingCipher().getBlockSize() : underlyingCipher.getBlockSize())));
        }
        return this.ivSize;
    }
}

