/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local;

import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.io.ByteArrayOutputStream;
import co.codewizards.cloudstore.core.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.KeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.crypto.AsymCombiDecrypterInputStream;
import org.subshare.core.crypto.AsymCombiEncrypterOutputStream;
import org.subshare.core.crypto.CipherTransformation;
import org.subshare.core.crypto.CryptoConfigUtil;
import org.subshare.core.crypto.DecrypterInputStream;
import org.subshare.core.crypto.DefaultKeyParameterFactory;
import org.subshare.core.crypto.EncrypterOutputStream;
import org.subshare.core.crypto.IvFactory;
import org.subshare.core.crypto.KeyParameterFactory;
import org.subshare.core.crypto.RandomIvFactory;
import org.subshare.core.dto.CryptoKeyPart;
import org.subshare.core.dto.CryptoKeyType;
import org.subshare.core.user.UserRepoKey;
import org.subshare.local.CryptreeNode;
import org.subshare.local.PlainCryptoKey;
import org.subshare.local.persistence.CryptoKey;
import org.subshare.local.persistence.CryptoLink;
import org.subshare.local.persistence.UserRepoKeyPublicKey;

public class CryptreeNodeUtil {
    private static final Logger logger = LoggerFactory.getLogger(CryptreeNodeUtil.class);
    private static final int MAX_ASYMMETRIC_PLAIN_SIZE = 64;

    public static byte[] encryptLarge(byte[] plain, UserRepoKeyPublicKey userRepoKeyPublicKey) {
        Objects.requireNonNull(plain, "plain");
        Objects.requireNonNull(userRepoKeyPublicKey, "userRepoKeyPublicKey");
        if (logger.isTraceEnabled()) {
            logger.trace("encryptLarge: userRepoKeyId={} plain={}", (Object)userRepoKeyPublicKey.getUserRepoKeyId(), (Object)Arrays.toString(plain));
        }
        AsymmetricKeyParameter publicKey = userRepoKeyPublicKey.getPublicKey().getPublicKey();
        return CryptreeNodeUtil.encryptLarge(plain, publicKey);
    }

    public static byte[] encryptLarge(byte[] plain, AsymmetricKeyParameter publicKey) {
        Objects.requireNonNull(plain, "plain");
        Objects.requireNonNull(publicKey, "publicKey");
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(plain.length + 10240);
            AsymCombiEncrypterOutputStream out = new AsymCombiEncrypterOutputStream((OutputStream)bout, CryptreeNodeUtil.getCipherTransformation((CipherParameters)publicKey), publicKey, CryptoConfigUtil.getSymmetricCipherTransformation(), (KeyParameterFactory)new DefaultKeyParameterFactory());
            IOUtil.transferStreamData((InputStream)new ByteArrayInputStream(plain), (OutputStream)out);
            out.close();
            byte[] encrypted = bout.toByteArray();
            if (logger.isTraceEnabled()) {
                logger.trace("encryptLarge: encrypted={}", (Object)Arrays.toString(encrypted));
            }
            return encrypted;
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public static byte[] decryptLarge(byte[] encrypted, UserRepoKey userRepoKey) {
        Objects.requireNonNull(encrypted, "encrypted");
        Objects.requireNonNull(userRepoKey, "userRepoKey");
        if (logger.isTraceEnabled()) {
            logger.trace("decryptLarge: userRepoKeyId={} encrypted={}", (Object)userRepoKey.getUserRepoKeyId(), (Object)Arrays.toString(encrypted));
        }
        AsymmetricKeyParameter privateKey = userRepoKey.getKeyPair().getPrivate();
        return CryptreeNodeUtil.decryptLarge(encrypted, privateKey);
    }

    public static byte[] decryptLarge(byte[] encrypted, AsymmetricKeyParameter privateKey) {
        Objects.requireNonNull(encrypted, "encrypted");
        Objects.requireNonNull(privateKey, "privateKey");
        try {
            AsymCombiDecrypterInputStream in = new AsymCombiDecrypterInputStream((InputStream)new ByteArrayInputStream(encrypted), privateKey);
            ByteArrayOutputStream out = new ByteArrayOutputStream(encrypted.length);
            IOUtil.transferStreamData((InputStream)in, (OutputStream)out);
            in.close();
            byte[] plain = out.toByteArray();
            if (logger.isTraceEnabled()) {
                logger.trace("decryptLarge: plain={}", (Object)Arrays.toString(plain));
            }
            return plain;
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public static byte[] encrypt(byte[] plain, PlainCryptoKey plainCryptoKey) {
        switch (plainCryptoKey.getCryptoKeyPart()) {
            case privateKey: {
                throw new IllegalStateException("Cannot encrypt with private key!");
            }
            case publicKey: {
                return CryptreeNodeUtil.encrypt(plain, (CipherParameters)plainCryptoKey.getPublicKeyParameterOrFail());
            }
            case sharedSecret: {
                return CryptreeNodeUtil.encrypt(plain, (CipherParameters)plainCryptoKey.getKeyParameterOrFail());
            }
        }
        throw new IllegalStateException("Unknown plainCryptoKey.cryptoKeyPart: " + plainCryptoKey.getCryptoKeyPart());
    }

    public static byte[] decrypt(byte[] encrypted, PlainCryptoKey plainCryptoKey) {
        switch (plainCryptoKey.getCryptoKeyPart()) {
            case privateKey: {
                return CryptreeNodeUtil.decrypt(encrypted, (CipherParameters)plainCryptoKey.getPrivateKeyParameterOrFail());
            }
            case publicKey: {
                throw new IllegalStateException("Cannot decrypt with public key!");
            }
            case sharedSecret: {
                return CryptreeNodeUtil.decrypt(encrypted, (CipherParameters)plainCryptoKey.getKeyParameterOrFail());
            }
        }
        throw new IllegalStateException("Unknown plainCryptoKey.cryptoKeyPart: " + plainCryptoKey.getCryptoKeyPart());
    }

    public static byte[] encrypt(byte[] plain, CipherParameters key) {
        Objects.requireNonNull(plain, "plain");
        Objects.requireNonNull(key, "key");
        if (key instanceof AsymmetricKeyParameter) {
            boolean large;
            boolean bl = large = plain.length > 64;
            if (large) {
                return CryptreeNodeUtil.encryptLarge(plain, (AsymmetricKeyParameter)key);
            }
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(plain.length + 10240);
            CipherTransformation cipherTransformation = CryptreeNodeUtil.getCipherTransformation(key);
            EncrypterOutputStream out = new EncrypterOutputStream((OutputStream)bout, cipherTransformation, key, (IvFactory)(CryptoKeyType.asymmetric == cipherTransformation.getType() ? null : new RandomIvFactory()));
            IOUtil.transferStreamData((InputStream)new ByteArrayInputStream(plain), (OutputStream)out);
            out.close();
            return bout.toByteArray();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public static byte[] decrypt(byte[] encrypted, CipherParameters key) {
        Objects.requireNonNull(encrypted, "encrypted");
        Objects.requireNonNull(key, "key");
        if (key instanceof AsymmetricKeyParameter) {
            int magicByte = encrypted[0] & 0xFF;
            if (195 == magicByte) {
                return CryptreeNodeUtil.decryptLarge(encrypted, (AsymmetricKeyParameter)key);
            }
            if (60 != magicByte) {
                throw new IllegalArgumentException(String.format("First byte from input does not match any expected magic number! expected1=%s expected2=%s found=%s", 195, 60, magicByte));
            }
        }
        try {
            DecrypterInputStream in = new DecrypterInputStream((InputStream)new ByteArrayInputStream(encrypted), key);
            ByteArrayOutputStream out = new ByteArrayOutputStream(encrypted.length);
            IOUtil.transferStreamData((InputStream)in, (OutputStream)out);
            in.close();
            return out.toByteArray();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public static CryptoLink createCryptoLink(CryptreeNode cryptreeNode, PlainCryptoKey fromPlainCryptoKey, PlainCryptoKey toPlainCryptoKey) {
        Objects.requireNonNull(cryptreeNode, "cryptreeNode");
        Objects.requireNonNull(fromPlainCryptoKey, "fromPlainCryptoKey");
        Objects.requireNonNull(toPlainCryptoKey, "toPlainCryptoKey");
        CryptoLink cryptoLink = new CryptoLink();
        cryptoLink.setFromCryptoKey(fromPlainCryptoKey.getCryptoKey());
        cryptoLink.setToCryptoKey(toPlainCryptoKey.getCryptoKey());
        cryptoLink.setToCryptoKeyData(CryptreeNodeUtil.encrypt(toPlainCryptoKey.getEncodedKey(), fromPlainCryptoKey));
        cryptoLink.setToCryptoKeyPart(toPlainCryptoKey.getCryptoKeyPart());
        cryptoLink.setLastSyncFromRepositoryId(null);
        cryptreeNode.sign(cryptoLink);
        toPlainCryptoKey.getCryptoKey().getInCryptoLinks().add(cryptoLink);
        CryptreeNodeUtil.assertToCryptoKeyBelongsToThisCryptreeNode(cryptreeNode, cryptoLink);
        return cryptoLink;
    }

    private static void assertToCryptoKeyBelongsToThisCryptreeNode(CryptreeNode cryptreeNode, CryptoLink cryptoLink) {
        Objects.requireNonNull(cryptreeNode, "cryptreeNode");
        Objects.requireNonNull(cryptoLink, "cryptoLink");
        CryptoKey toCryptoKey = Objects.requireNonNull(cryptoLink.getToCryptoKey(), "cryptoLink.toCryptoKey");
        Objects.requireNonNull(cryptreeNode.getCryptoRepoFile(), "cryptreeNode.cryptoRepoFile");
        Objects.requireNonNull(toCryptoKey.getCryptoRepoFile(), "toCryptoKey.cryptoRepoFile");
        if (!toCryptoKey.getCryptoRepoFile().equals((Object)cryptreeNode.getCryptoRepoFile())) {
            throw new IllegalStateException(String.format("cryptoLink.toCryptoKey.cryptoRepoFile != cryptreeNode.cryptoRepoFile :: cryptoLink=%s cryptoLink.toCryptoKey.cryptoRepoFile=%s cryptreeNode.cryptoRepoFile=%s", new Object[]{cryptoLink, toCryptoKey.getCryptoRepoFile(), cryptreeNode.getCryptoRepoFile()}));
        }
    }

    public static CryptoLink createCryptoLink(CryptreeNode cryptreeNode, UserRepoKeyPublicKey fromUserRepoKeyPublicKey, PlainCryptoKey toPlainCryptoKey) {
        Objects.requireNonNull(cryptreeNode, "cryptreeNode");
        Objects.requireNonNull(fromUserRepoKeyPublicKey, "fromUserRepoKeyPublicKey");
        Objects.requireNonNull(toPlainCryptoKey, "toPlainCryptoKey");
        CryptoLink cryptoLink = new CryptoLink();
        cryptoLink.setFromUserRepoKeyPublicKey(fromUserRepoKeyPublicKey);
        cryptoLink.setToCryptoKey(toPlainCryptoKey.getCryptoKey());
        cryptoLink.setToCryptoKeyData(CryptreeNodeUtil.encryptLarge(toPlainCryptoKey.getEncodedKey(), fromUserRepoKeyPublicKey));
        cryptoLink.setToCryptoKeyPart(toPlainCryptoKey.getCryptoKeyPart());
        cryptoLink.setLastSyncFromRepositoryId(null);
        cryptreeNode.sign(cryptoLink);
        toPlainCryptoKey.getCryptoKey().getInCryptoLinks().add(cryptoLink);
        CryptreeNodeUtil.assertToCryptoKeyBelongsToThisCryptreeNode(cryptreeNode, cryptoLink);
        return cryptoLink;
    }

    public static CryptoLink createCryptoLink(CryptreeNode cryptreeNode, PlainCryptoKey toPlainCryptoKey) {
        Objects.requireNonNull(cryptreeNode, "cryptreeNode");
        Objects.requireNonNull(toPlainCryptoKey, "toPlainCryptoKey");
        if (CryptoKeyPart.publicKey != toPlainCryptoKey.getCryptoKeyPart()) {
            throw new IllegalArgumentException("You probably do not want to create a plain-text - i.e. *not* encrypted - CryptoLink to a key[part] of type: " + toPlainCryptoKey.getCryptoKeyPart());
        }
        CryptoLink cryptoLink = new CryptoLink();
        cryptoLink.setToCryptoKey(toPlainCryptoKey.getCryptoKey());
        cryptoLink.setToCryptoKeyData(toPlainCryptoKey.getEncodedKey());
        cryptoLink.setToCryptoKeyPart(toPlainCryptoKey.getCryptoKeyPart());
        cryptoLink.setLastSyncFromRepositoryId(null);
        cryptreeNode.sign(cryptoLink);
        toPlainCryptoKey.getCryptoKey().getInCryptoLinks().add(cryptoLink);
        CryptreeNodeUtil.assertToCryptoKeyBelongsToThisCryptreeNode(cryptreeNode, cryptoLink);
        return cryptoLink;
    }

    private static CipherTransformation getCipherTransformation(CipherParameters key) {
        Objects.requireNonNull(key, "key");
        if (key instanceof KeyParameter) {
            return CryptoConfigUtil.getSymmetricCipherTransformation();
        }
        if (key instanceof AsymmetricKeyParameter) {
            return CryptoConfigUtil.getAsymmetricCipherTransformation();
        }
        throw new IllegalArgumentException("Unexpected key type: " + key.getClass().getName());
    }
}

