/*
 * Decompiled with CFR 0.152.
 */
package co.codewizards.cloudstore.local.persistence;

import co.codewizards.cloudstore.core.util.HashUtil;
import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.FileInProgressMarker;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInProgressMarkerDao
extends Dao<FileInProgressMarker, FileInProgressMarkerDao> {
    private static final Logger logger = LoggerFactory.getLogger(FileInProgressMarkerDao.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FileInProgressMarker> getFileInProgressMarkers(UUID fromRepository, UUID toRepository) {
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getFileInProgressMarkers_fromRepositoryId_toRepositoryId");
        try {
            Collection fileInProgressMarkers = (Collection)query.execute((Object)FileInProgressMarkerDao.convertToString(fromRepository), (Object)FileInProgressMarkerDao.convertToString(toRepository));
            Collection<FileInProgressMarker> collection = this.load(fileInProgressMarkers);
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInProgressMarker getFileInProgressMarker(UUID fromRepositoryId, UUID toRepositoryId, String path) {
        Objects.requireNonNull(fromRepositoryId, "fromRepositoryId");
        Objects.requireNonNull(toRepositoryId, "toRepositoryId");
        Objects.requireNonNull(path, "path");
        String pathSha1 = HashUtil.sha1((String)path);
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getFileInProgressMarker_fromRepositoryId_toRepositoryId_pathSha1");
        try {
            FileInProgressMarker result;
            HashMap<String, String> m = new HashMap<String, String>(3);
            m.put("fromRepositoryId", fromRepositoryId.toString());
            m.put("toRepositoryId", toRepositoryId.toString());
            m.put("pathSha1", pathSha1);
            FileInProgressMarker fileInProgressMarker = result = (FileInProgressMarker)query.executeWithMap(m);
            return fileInProgressMarker;
        }
        finally {
            query.closeAll();
        }
    }

    public void deleteFileInProgressMarkers(UUID fromRepositoryId, UUID toRepositoryId) {
        Collection<FileInProgressMarker> fileInProgressMarkers = this.getFileInProgressMarkers(fromRepositoryId, toRepositoryId);
        if (fileInProgressMarkers.size() > 0) {
            logger.info("deleteFileInProgressMarkers: deleting {} FileInProgressMarker(s) from={}, to={}", new Object[]{fileInProgressMarkers.size(), fromRepositoryId, toRepositoryId});
            this.deletePersistentAll(fileInProgressMarkers);
        }
    }

    static UUID convertToUuid(String repositoryId) {
        return repositoryId == null ? null : UUID.fromString(repositoryId);
    }

    static String convertToString(UUID repositoryId) {
        return repositoryId == null ? null : repositoryId.toString();
    }
}

