/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.bouncycastle.openpgp.wot.IoFile;
import org.bouncycastle.openpgp.wot.PgpRandomAccessFile;
import org.bouncycastle.openpgp.wot.internal.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoRandomAccessFile
implements PgpRandomAccessFile {
    private static final Logger logger = LoggerFactory.getLogger(IoRandomAccessFile.class);
    private final IoFile ioFile;
    private final File file;
    private final RandomAccessFile raf;
    private final FileLock fileLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoRandomAccessFile(IoFile ioFile) throws IOException {
        this.ioFile = Util.assertNotNull(ioFile, "ioFile");
        this.file = Util.assertNotNull(this.ioFile.getFile(), "ioFile.file");
        RandomAccessFile raf = null;
        FileLock fileLock = null;
        try {
            raf = new RandomAccessFile(this.file, "rw");
            int timeoutMillis = 60000;
            int sleepMillis = 500;
            int tryCount = 120;
            for (int i = 0; i < 120; ++i) {
                if (fileLock == null && i != 0) {
                    logger.warn("Locking file '{}' failed. Retrying.", (Object)this.file.getAbsolutePath());
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        Util.doNothing();
                    }
                }
                try {
                    fileLock = raf.getChannel().tryLock();
                }
                catch (OverlappingFileLockException y) {
                    Util.doNothing();
                }
                if (fileLock != null) break;
            }
            if (fileLock == null) {
                fileLock = raf.getChannel().lock();
            }
        }
        finally {
            if (fileLock == null && raf != null) {
                try {
                    raf.close();
                }
                catch (Exception e) {
                    logger.warn("Closing file failed: " + e, (Throwable)e);
                }
            }
        }
        this.raf = raf;
        this.fileLock = fileLock;
    }

    @Override
    public void close() throws IOException {
        this.fileLock.release();
        this.raf.close();
    }

    @Override
    public void flush() throws IOException {
        this.raf.getFD().sync();
    }

    @Override
    public long getLength() throws IOException {
        return this.raf.length();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
    }

    @Override
    public void readFully(byte[] buf) throws EOFException, IOException {
        this.raf.readFully(buf);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.raf.write(buf);
    }
}

