/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.backup;

import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.ls.client.util.ByteArrayInputStreamLs;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.subshare.core.locker.LockerContent;
import org.subshare.core.server.ServerRegistryLockerContent;
import org.subshare.gui.backup.AbstractBackupImExporter;
import org.subshare.gui.backup.BackupDataFile;
import org.subshare.gui.ls.UserRegistryLs;

public class BackupImporter
extends AbstractBackupImExporter {
    public void importBackup(File backupFile) throws IOException {
        BackupDataFile backupDataFile;
        Objects.requireNonNull(backupFile, "backupFile");
        backupFile.getParentFile().mkdirs();
        try (InputStream in = StreamUtil.castStream((IInputStream)backupFile.createInputStream());){
            backupDataFile = new BackupDataFile(in);
        }
        UserRegistryLs.getUserRegistry();
        byte[] pgpKeyData = backupDataFile.getData("public+secret_keys.gpg");
        Objects.requireNonNull(pgpKeyData, "backupDataFile.getData(ENTRY_NAME_PGP_KEYS)");
        this.pgp.importKeys((IInputStream)ByteArrayInputStreamLs.create((byte[])pgpKeyData));
        LockerContent serverRegistryLockerContent = (LockerContent)this.localServerClient.invokeConstructor(ServerRegistryLockerContent.class, new Object[0]);
        byte[] serverRegistryData = backupDataFile.getData("serverRegistry.subshare");
        Objects.requireNonNull(serverRegistryData, "backupDataFile.getData(ENTRY_NAME_SERVER_REGISTRY_FILE)");
        serverRegistryLockerContent.mergeFrom(serverRegistryData);
        this.registerPgpKeyRelatedBackupProperties(backupDataFile.getManifestTimestamp());
        this.registerServerRegistryRelatedBackupProperties(backupDataFile.getManifestTimestamp());
        this.writeBackupProperties();
    }
}

