/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.filetree.repoaware;

import co.codewizards.cloudstore.core.collection.WeakIdentityHashMap;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.util.Callback;
import org.subshare.core.repo.LocalRepo;
import org.subshare.core.repo.local.CollisionPrivateFilter;
import org.subshare.core.repo.local.SsLocalRepoMetaData;
import org.subshare.gui.concurrent.SsTask;
import org.subshare.gui.filetree.FileFileTreeItem;
import org.subshare.gui.filetree.FileTreeItem;
import org.subshare.gui.filetree.FileTreePane;
import org.subshare.gui.filetree.repoaware.CollisionPrivateDtoSet;
import org.subshare.gui.ls.LocalRepoManagerFactoryLs;
import org.subshare.gui.util.PlatformUtil;

public class RepoAwareFileTreePane
extends FileTreePane {
    private LocalRepo localRepo;
    private static Image collisionUnresolvedIcon;
    private static Image collisionUnresolvedInChildIcon;
    private final WeakIdentityHashMap<FileTreeItem<?>, CollisionPrivateDtoSet> treeItem2CollisionDtoSet = new WeakIdentityHashMap();
    private final WeakIdentityHashMap<FileTreeItem<?>, ImageView> treeItem2CollisionIconImageView = new WeakIdentityHashMap();
    private final Callback<TreeTableColumn<FileTreeItem<?>, String>, TreeTableCell<FileTreeItem<?>, String>> nameColumnCellFactory = new Callback<TreeTableColumn<FileTreeItem<?>, String>, TreeTableCell<FileTreeItem<?>, String>>(){

        public TreeTableCell<FileTreeItem<?>, String> call(TreeTableColumn<FileTreeItem<?>, String> param) {
            return new TreeTableCell<FileTreeItem<?>, String>(){

                protected void updateItem(String value, boolean empty) {
                    super.updateItem((Object)value, empty);
                    FileTreeItem treeItem = (FileTreeItem)((Object)this.getTreeTableRow().getItem());
                    if (value == null || treeItem == null || empty) {
                        this.setText(null);
                        this.setGraphic(null);
                    } else {
                        this.setText(value);
                        this.setGraphic((Node)RepoAwareFileTreePane.this.treeItem2CollisionIconImageView.get((Object)treeItem));
                        RepoAwareFileTreePane.this.updateGraphicAsync(this, treeItem);
                    }
                }
            };
        }
    };

    private void updateGraphicAsync(final TreeTableCell<FileTreeItem<?>, String> treeTableCell, final FileTreeItem<?> treeItem) {
        new Service<CollisionPrivateDtoSet>(){

            protected Task<CollisionPrivateDtoSet> createTask() {
                return new SsTask<CollisionPrivateDtoSet>(){

                    protected CollisionPrivateDtoSet call() throws Exception {
                        if (RepoAwareFileTreePane.this.localRepo == null) {
                            return new CollisionPrivateDtoSet(Collections.emptyList(), Collections.emptyList());
                        }
                        return RepoAwareFileTreePane.this._getCollisionDtoSet(treeItem);
                    }

                    protected void succeeded() {
                        ImageView iconImageView;
                        CollisionPrivateDtoSet collisionPrivateDtoSet;
                        try {
                            collisionPrivateDtoSet = (CollisionPrivateDtoSet)this.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                        if (collisionPrivateDtoSet == null) {
                            RepoAwareFileTreePane.this.treeItem2CollisionDtoSet.remove((Object)treeItem);
                        } else {
                            RepoAwareFileTreePane.this.treeItem2CollisionDtoSet.put((Object)treeItem, (Object)collisionPrivateDtoSet);
                        }
                        Image icon = RepoAwareFileTreePane.this._getCollisionIcon(collisionPrivateDtoSet);
                        ImageView imageView = iconImageView = icon == null ? null : new ImageView(icon);
                        if (iconImageView == null) {
                            RepoAwareFileTreePane.this.treeItem2CollisionIconImageView.remove((Object)treeItem);
                        } else {
                            RepoAwareFileTreePane.this.treeItem2CollisionIconImageView.put((Object)treeItem, (Object)iconImageView);
                        }
                        FileTreeItem currentTreeItem = (FileTreeItem)((Object)treeTableCell.getTreeTableRow().getItem());
                        if (currentTreeItem == treeItem) {
                            treeTableCell.setGraphic((Node)iconImageView);
                        }
                    }
                };
            }
        }.start();
    }

    public CollisionPrivateDtoSet getCollisionDtoSet(FileTreeItem<?> treeItem) {
        Objects.requireNonNull(treeItem, "treeItem");
        PlatformUtil.assertFxApplicationThread();
        return (CollisionPrivateDtoSet)this.treeItem2CollisionDtoSet.get(treeItem);
    }

    public RepoAwareFileTreePane() {
        this.getNameTreeTableColumn().setCellFactory(this.nameColumnCellFactory);
    }

    public LocalRepo getLocalRepo() {
        return this.localRepo;
    }

    public void setLocalRepo(LocalRepo localRepo) {
        this.localRepo = localRepo;
    }

    private Image _getCollisionIcon(CollisionPrivateDtoSet collisionPrivateDtoSet) {
        if (collisionPrivateDtoSet == null) {
            return null;
        }
        if (collisionPrivateDtoSet.getAllCollisionPrivateDtos().isEmpty()) {
            return null;
        }
        if (collisionPrivateDtoSet.getDirectCollisionPrivateDtos().isEmpty()) {
            return RepoAwareFileTreePane.getCollisionUnresolvedInChildIcon();
        }
        return RepoAwareFileTreePane.getCollisionUnresolvedIcon();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CollisionPrivateDtoSet _getCollisionDtoSet(FileTreeItem<?> treeItem) {
        Objects.requireNonNull(treeItem, "treeItem");
        if (!(treeItem instanceof FileFileTreeItem)) {
            return null;
        }
        Class<RepoAwareFileTreePane> clazz = RepoAwareFileTreePane.class;
        synchronized (RepoAwareFileTreePane.class) {
            FileFileTreeItem ffti = (FileFileTreeItem)treeItem;
            String localPath = this.localRepo.getLocalPath(ffti.getFile());
            try (LocalRepoManager localRepoManager = this.createLocalRepoManager();){
                SsLocalRepoMetaData localRepoMetaData = (SsLocalRepoMetaData)localRepoManager.getLocalRepoMetaData();
                CollisionPrivateFilter filter = new CollisionPrivateFilter();
                filter.setLocalPath(localPath);
                filter.setResolved(Boolean.valueOf(false));
                filter.setIncludeChildrenRecursively(true);
                Collection allCollisionDtos = localRepoMetaData.getCollisionPrivateDtos(filter);
                if (allCollisionDtos.isEmpty()) {
                    CollisionPrivateDtoSet collisionPrivateDtoSet = new CollisionPrivateDtoSet(Collections.emptyList(), Collections.emptyList());
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return collisionPrivateDtoSet;
                }
                filter.setIncludeChildrenRecursively(false);
                Collection directCollisionDtos = localRepoMetaData.getCollisionPrivateDtos(filter);
                CollisionPrivateDtoSet collisionPrivateDtoSet = new CollisionPrivateDtoSet(allCollisionDtos, directCollisionDtos);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return collisionPrivateDtoSet;
            }
        }
    }

    public static Image getCollisionUnresolvedIcon() {
        if (collisionUnresolvedIcon == null) {
            String fileName = "collision-unresolved_16x16.png";
            URL url = RepoAwareFileTreePane.class.getResource("collision-unresolved_16x16.png");
            if (url == null) {
                throw new IllegalArgumentException(String.format("Resource '%s' not found!", "collision-unresolved_16x16.png"));
            }
            collisionUnresolvedIcon = new Image(url.toExternalForm());
        }
        return collisionUnresolvedIcon;
    }

    public static Image getCollisionUnresolvedInChildIcon() {
        if (collisionUnresolvedInChildIcon == null) {
            String fileName = "collision-unresolved-child_16x16.png";
            URL url = RepoAwareFileTreePane.class.getResource("collision-unresolved-child_16x16.png");
            if (url == null) {
                throw new IllegalArgumentException(String.format("Resource '%s' not found!", "collision-unresolved-child_16x16.png"));
            }
            collisionUnresolvedInChildIcon = new Image(url.toExternalForm());
        }
        return collisionUnresolvedInChildIcon;
    }

    private LocalRepoManager createLocalRepoManager() {
        LocalRepo localRepo = Objects.requireNonNull(this.getLocalRepo(), "localRepo");
        return LocalRepoManagerFactoryLs.getLocalRepoManagerFactory().createLocalRepoManagerForExistingRepository(localRepo.getLocalRoot());
    }

    @Override
    public void refresh() {
        this.treeItem2CollisionDtoSet.clear();
        this.treeItem2CollisionIconImageView.clear();
        super.refresh();
    }
}

