/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.localrepolist;

import co.codewizards.cloudstore.core.Severity;
import co.codewizards.cloudstore.core.bean.Bean;
import co.codewizards.cloudstore.core.bean.PropertyBase;
import co.codewizards.cloudstore.core.bean.PropertyChangeListenerUtil;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncActivity;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncDaemon;
import co.codewizards.cloudstore.core.repo.sync.RepoSyncState;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.subshare.core.repo.LocalRepo;
import org.subshare.core.repo.LocalRepoRegistry;
import org.subshare.gui.IconSize;
import org.subshare.gui.concurrent.SsTask;
import org.subshare.gui.createrepo.CreateRepoData;
import org.subshare.gui.createrepo.CreateRepoWizard;
import org.subshare.gui.invitation.accept.AcceptInvitationWizard;
import org.subshare.gui.localrepolist.LocalRepoListItem;
import org.subshare.gui.ls.LocalRepoRegistryLs;
import org.subshare.gui.ls.RepoSyncDaemonLs;
import org.subshare.gui.severity.SeverityImageRegistry;
import org.subshare.gui.util.FxmlUtil;
import org.subshare.gui.wizard.WizardDialog;

public class LocalRepoListPane
extends GridPane {
    private static final Image syncIcon = new Image(LocalRepoListPane.class.getResource("sync_16x16.png").toExternalForm());
    @FXML
    private Button syncAllButton;
    @FXML
    private Button syncButton;
    @FXML
    private TableColumn<LocalRepoListItem, Set<RepoSyncActivity>> repoSyncActivityIconColumn;
    @FXML
    private TableColumn<LocalRepoListItem, Severity> severityIconColumn;
    @FXML
    private TableView<LocalRepoListItem> tableView;
    private LocalRepoRegistry localRepoRegistry;
    private RepoSyncDaemon repoSyncDaemon;
    private final PropertyChangeListener localReposPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LinkedHashSet localRepos = new LinkedHashSet((List)evt.getNewValue());
            Platform.runLater(() -> LocalRepoListPane.this.addOrRemoveTableItemsViewCallback(localRepos));
        }
    };
    private final PropertyChangeListener repoSyncDaemonPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Platform.runLater(() -> {
                for (LocalRepoListItem localRepoListItem : LocalRepoListPane.this.tableView.getItems()) {
                    LocalRepoListPane.this.updateSyncStates(localRepoListItem);
                }
            });
        }
    };

    public LocalRepoListPane() {
        FxmlUtil.loadDynamicComponentFxml(LocalRepoListPane.class, this);
        this.repoSyncActivityIconColumn.setCellFactory(l -> new TableCell<LocalRepoListItem, Set<RepoSyncActivity>>(){

            public void updateItem(Set<RepoSyncActivity> activities, boolean empty) {
                ImageView imageView = null;
                Tooltip tooltip = null;
                if (activities != null && !activities.isEmpty()) {
                    LocalRepoListItem listItem = (LocalRepoListItem)this.getTableRow().getItem();
                    if (listItem == null) {
                        return;
                    }
                    String tooltipText = listItem.getTooltipText();
                    imageView = new ImageView(syncIcon);
                    if (!StringUtil.isEmpty((String)tooltipText)) {
                        tooltip = new Tooltip(tooltipText);
                    }
                }
                this.setGraphic((Node)imageView);
                this.setTooltip(tooltip);
            }
        });
        this.severityIconColumn.setCellFactory(l -> new TableCell<LocalRepoListItem, Severity>(){

            public void updateItem(Severity severity, boolean empty) {
                ImageView imageView = null;
                Tooltip tooltip = null;
                if (severity != null) {
                    LocalRepoListItem listItem = (LocalRepoListItem)this.getTableRow().getItem();
                    if (listItem == null) {
                        return;
                    }
                    String tooltipText = listItem.getTooltipText();
                    imageView = new ImageView(SeverityImageRegistry.getInstance().getImage(severity, IconSize._16x16));
                    if (!StringUtil.isEmpty((String)tooltipText)) {
                        tooltip = new Tooltip(tooltipText);
                    }
                }
                this.setGraphic((Node)imageView);
                this.setTooltip(tooltip);
            }
        });
        this.tableView.getSelectionModel().getSelectedItems().addListener(observable -> this.updateEnabled());
        this.populateTableViewAsync();
        this.updateEnabled();
    }

    private void updateEnabled() {
        boolean selectionEmpty = this.tableView.getSelectionModel().getSelectedItems().isEmpty();
        this.syncButton.setDisable(selectionEmpty);
    }

    private void populateTableViewAsync() {
        new Service<Collection<LocalRepo>>(){

            protected Task<Collection<LocalRepo>> createTask() {
                return new SsTask<Collection<LocalRepo>>(){

                    protected Collection<LocalRepo> call() throws Exception {
                        LocalRepoListPane.this.getRepoSyncDaemon();
                        return LocalRepoListPane.this.getLocalRepoRegistry().getLocalRepos();
                    }

                    protected void succeeded() {
                        Collection localRepos;
                        try {
                            localRepos = (Collection)this.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                        LocalRepoListPane.this.addOrRemoveTableItemsViewCallback(localRepos);
                    }
                };
            }
        }.start();
    }

    @FXML
    private void createRepositoryButtonClicked(ActionEvent event) {
        CreateRepoData createRepoData = new CreateRepoData();
        CreateRepoWizard wizard = new CreateRepoWizard(createRepoData);
        WizardDialog dialog = new WizardDialog(this.getScene().getWindow(), wizard);
        dialog.show();
    }

    @FXML
    private void syncAllButtonClicked(ActionEvent event) {
        new Service<Void>(){

            protected Task<Void> createTask() {
                return new SsTask<Void>(){

                    protected Void call() throws Exception {
                        for (LocalRepo localRepo : LocalRepoListPane.this.getLocalRepoRegistry().getLocalRepos()) {
                            LocalRepoListPane.this.getRepoSyncDaemon().startSync(localRepo.getLocalRoot());
                        }
                        return null;
                    }
                };
            }
        }.start();
    }

    @FXML
    private void syncButtonClicked(ActionEvent event) {
        final ArrayList<File> selectedLocalRoots = new ArrayList<File>();
        for (LocalRepoListItem li : this.tableView.getSelectionModel().getSelectedItems()) {
            selectedLocalRoots.add(li.getLocalRoot());
        }
        new Service<Void>(){

            protected Task<Void> createTask() {
                return new SsTask<Void>(){

                    protected Void call() throws Exception {
                        for (File localRoot : selectedLocalRoots) {
                            LocalRepoListPane.this.getRepoSyncDaemon().startSync(localRoot);
                        }
                        return null;
                    }
                };
            }
        }.start();
    }

    @FXML
    private void acceptInvitationButtonClicked(ActionEvent event) {
        AcceptInvitationWizard wizard = new AcceptInvitationWizard();
        WizardDialog dialog = new WizardDialog(this.getScene().getWindow(), wizard);
        dialog.show();
    }

    protected void updateSyncStates(LocalRepoListItem localRepoListItem) {
        UUID localRepositoryId = localRepoListItem.getLocalRepo().getRepositoryId();
        List states = this.getRepoSyncDaemon().getStates(localRepositoryId);
        RepoSyncState state = states.isEmpty() ? null : (RepoSyncState)states.get(states.size() - 1);
        localRepoListItem.setRepoSyncState(state);
        Set activities = this.getRepoSyncDaemon().getActivities(localRepositoryId);
        System.err.println(activities);
        localRepoListItem.setRepoSyncActivities(activities);
    }

    protected LocalRepoRegistry getLocalRepoRegistry() {
        if (this.localRepoRegistry == null) {
            this.localRepoRegistry = LocalRepoRegistryLs.getLocalRepoRegistry();
            PropertyChangeListenerUtil.addWeakPropertyChangeListener((Bean)this.localRepoRegistry, (PropertyBase)LocalRepoRegistry.PropertyEnum.localRepos, (PropertyChangeListener)this.localReposPropertyChangeListener);
        }
        return this.localRepoRegistry;
    }

    protected RepoSyncDaemon getRepoSyncDaemon() {
        if (this.repoSyncDaemon == null) {
            this.repoSyncDaemon = RepoSyncDaemonLs.getRepoSyncDaemon();
            PropertyChangeListenerUtil.addWeakPropertyChangeListener((Object)this.repoSyncDaemon, (PropertyChangeListener)this.repoSyncDaemonPropertyChangeListener);
        }
        return this.repoSyncDaemon;
    }

    private void addOrRemoveTableItemsViewCallback(Collection<LocalRepo> localRepos) {
        Objects.requireNonNull(localRepos, "localRepos");
        HashMap<LocalRepo, LocalRepoListItem> viewLocalRepo2LocalRepoListItem = new HashMap<LocalRepo, LocalRepoListItem>();
        for (LocalRepoListItem li : this.tableView.getItems()) {
            viewLocalRepo2LocalRepoListItem.put(li.getLocalRepo(), li);
        }
        for (LocalRepo localRepo : localRepos) {
            if (viewLocalRepo2LocalRepoListItem.containsKey(localRepo)) continue;
            LocalRepoListItem li = new LocalRepoListItem(localRepo);
            this.updateSyncStates(li);
            viewLocalRepo2LocalRepoListItem.put(localRepo, li);
            this.tableView.getItems().add((Object)li);
        }
        if (localRepos.size() < viewLocalRepo2LocalRepoListItem.size()) {
            for (LocalRepo localRepo : localRepos) {
                viewLocalRepo2LocalRepoListItem.remove(localRepo);
            }
            for (LocalRepoListItem li : viewLocalRepo2LocalRepoListItem.values()) {
                this.tableView.getItems().remove((Object)li);
            }
        }
    }
}

