/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.keytree;

import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyValidity;
import org.subshare.gui.pgp.keytree.CertificationsPgpKeyTreeItem;
import org.subshare.gui.pgp.keytree.PgpKeyTreeItem;

public class UserIdPgpKeyTreeItem
extends PgpKeyTreeItem<String> {
    private final PgpKey pgpKey;

    public UserIdPgpKeyTreeItem(PgpKey pgpKey, String userId) {
        super(Objects.requireNonNull(userId, "userId"));
        this.pgpKey = Objects.requireNonNull(pgpKey, "pgpKey");
    }

    @Override
    public String getKeyValidity() {
        String userId = (String)this.getValueObject();
        PgpKeyValidity kv = this.getPgp().getKeyValidity(this.pgpKey, userId);
        return kv.toShortString();
    }

    public ObservableList<TreeItem<PgpKeyTreeItem<?>>> getChildren() {
        ObservableList children = super.getChildren();
        if (children.isEmpty()) {
            String userId = (String)this.getValueObject();
            children.add((Object)new CertificationsPgpKeyTreeItem(this.pgpKey, userId));
        }
        return children;
    }

    public boolean isLeaf() {
        return false;
    }
}

