/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.pgp.keytree;

import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import org.subshare.core.pgp.PgpKey;
import org.subshare.gui.pgp.keytree.PgpKeyTreeItem;
import org.subshare.gui.pgp.keytree.UserIdPgpKeyTreeItem;

public class UserIdsPgpKeyTreeItem
extends PgpKeyTreeItem<PgpKey> {
    private boolean childrenInitialised;

    public UserIdsPgpKeyTreeItem(PgpKey pgpKey) {
        super(Objects.requireNonNull(pgpKey, "pgpKey"));
    }

    public ObservableList<TreeItem<PgpKeyTreeItem<?>>> getChildren() {
        ObservableList children = super.getChildren();
        if (!this.childrenInitialised) {
            this.childrenInitialised = true;
            PgpKey pgpKey = (PgpKey)this.getValueObject();
            for (String userId : pgpKey.getUserIds()) {
                children.add((Object)new UserIdPgpKeyTreeItem(pgpKey, userId));
            }
        }
        return children;
    }

    public boolean isLeaf() {
        return false;
    }

    @Override
    public String getName() {
        return "Identities";
    }
}

