/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.selectuser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javafx.event.ActionEvent;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.subshare.core.user.User;
import org.subshare.gui.selectuser.SelectUserPaneWithButtonBar;

public class SelectUserDialog
extends Stage {
    private final SelectUserPaneWithButtonBar selectUserPane;
    private List<User> selectedUsers;

    public SelectUserDialog(Window owner, List<User> users, Collection<User> selectedUsers, SelectionMode selectionMode, String headerText) {
        Objects.requireNonNull(owner, "owner");
        Objects.requireNonNull(users, "users");
        this.setResizable(false);
        this.initStyle(StageStyle.UTILITY);
        this.initModality(Modality.APPLICATION_MODAL);
        this.initOwner(owner);
        this.setIconified(false);
        this.selectUserPane = new SelectUserPaneWithButtonBar(users, selectedUsers, selectionMode, headerText){

            @Override
            protected void okButtonClicked(ActionEvent event) {
                SelectUserDialog.this.okButtonClicked();
            }

            @Override
            protected void cancelButtonClicked(ActionEvent event) {
                SelectUserDialog.this.cancelButtonClicked();
            }
        };
        this.setScene(new Scene((Parent)this.selectUserPane));
        this.setOnShown(event -> {
            this.requestFocus();
            this.selectUserPane.requestFocus();
        });
        this.getScene().addEventFilter(KeyEvent.ANY, event -> {
            switch (event.getCode()) {
                case ENTER: {
                    event.consume();
                    if (event.getEventType() != KeyEvent.KEY_RELEASED) break;
                    this.okButtonClicked();
                    break;
                }
                case ESCAPE: {
                    event.consume();
                    if (event.getEventType() != KeyEvent.KEY_RELEASED) break;
                    this.cancelButtonClicked();
                    break;
                }
            }
        });
    }

    protected void okButtonClicked() {
        this.selectedUsers = new ArrayList<User>((Collection<User>)this.selectUserPane.getSelectedUsers());
        this.close();
    }

    protected void cancelButtonClicked() {
        this.selectedUsers = null;
        this.close();
    }

    public List<User> getSelectedUsers() {
        return this.selectedUsers;
    }
}

