/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.gui.welcome;

import co.codewizards.cloudstore.core.progress.ProgressMonitor;
import co.codewizards.cloudstore.core.util.StringUtil;
import java.util.Objects;
import org.subshare.core.server.Server;
import org.subshare.core.server.ServerRegistry;
import org.subshare.core.sync.Sync;
import org.subshare.gui.invitation.accept.AcceptInvitationManager;
import org.subshare.gui.ls.LockerSyncLs;
import org.subshare.gui.ls.PgpSyncLs;
import org.subshare.gui.ls.ServerRegistryLs;
import org.subshare.gui.welcome.Messages;
import org.subshare.gui.welcome.ServerData;
import org.subshare.gui.welcome.first.FirstWizardPage;
import org.subshare.gui.welcome.server.ServerWizardPage;
import org.subshare.gui.wizard.DefaultFinishingPage;
import org.subshare.gui.wizard.Wizard;

public class ServerWizard
extends Wizard {
    private final ServerData serverData = new ServerData();
    private final boolean syncLocker;
    private final ServerRegistry serverRegistry;
    private boolean needed;

    public ServerWizard(boolean showFirstPage, boolean syncLocker) {
        this.syncLocker = syncLocker;
        if (showFirstPage) {
            this.setFirstPage(new FirstWizardPage());
        }
        this.serverRegistry = ServerRegistryLs.getServerRegistry();
        if (this.serverRegistry.getServers().isEmpty()) {
            this.needed = true;
            this.serverData.setServer(this.serverRegistry.createServer());
            if (this.getFirstPage() == null) {
                this.setFirstPage(new ServerWizardPage(this.serverData));
            } else {
                this.getFirstPage().setNextPage(new ServerWizardPage(this.serverData));
            }
        }
    }

    @Override
    public void init() {
        super.init();
        this.setPrefSize(500.0, 500.0);
    }

    public ServerData getServerData() {
        return this.serverData;
    }

    @Override
    public String getTitle() {
        return Messages.getString("ServerWizard.title");
    }

    public boolean isNeeded() {
        return this.needed;
    }

    @Override
    protected void finishing() {
        if (this.serverData.acceptInvitationProperty().get()) {
            ((DefaultFinishingPage)this.getFinishingPage()).getHeaderText().setText(Messages.getString("ServerWizard.finishingPage.headerText.text[acceptInvitation]"));
        } else {
            if (StringUtil.isEmpty((String)StringUtil.trim((String)this.serverData.getServer().getName()))) {
                this.serverData.getServer().setName(this.serverData.getServer().getUrl().getHost());
            }
            ((DefaultFinishingPage)this.getFinishingPage()).getHeaderText().setText(Messages.getString("ServerWizard.finishingPage.headerText.text[registerServer]"));
        }
        super.finishing();
    }

    @Override
    protected void finish(ProgressMonitor monitor) throws Exception {
        if (this.serverData.acceptInvitationProperty().get()) {
            this.finish_acceptInvitation(monitor);
        } else {
            this.finish_registerServer(monitor);
        }
    }

    protected void finish_acceptInvitation(ProgressMonitor monitor) throws Exception {
        new AcceptInvitationManager().acceptInvitation(this.serverData.getAcceptInvitationData());
    }

    protected void finish_registerServer(ProgressMonitor monitor) throws Exception {
        Server server = Objects.requireNonNull(this.serverData.getServer(), "serverData.server");
        if (this.syncLocker) {
            try (Sync pgpSync = PgpSyncLs.createPgpSync(server);){
                pgpSync.sync();
            }
            var4_4 = null;
            try (Sync lockerSync = LockerSyncLs.createLockerSync(server);){
                lockerSync.sync();
            }
            catch (Throwable throwable) {
                var4_4 = throwable;
                throw throwable;
            }
            Server server2 = this.serverRegistry.getServerForRemoteRoot(server.getUrl());
            if (server2 == null) {
                this.serverRegistry.getServers().add(server);
            }
        } else {
            this.serverRegistry.getServers().add(server);
        }
    }
}

