/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.crypto;

import co.codewizards.cloudstore.core.util.IOUtil;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.subshare.core.crypto.CipherTransformation;
import org.subshare.core.crypto.EncrypterDecrypterStreamUtil;
import org.subshare.crypto.Cipher;
import org.subshare.crypto.CipherOperationMode;
import org.subshare.crypto.CryptoRegistry;

public class DecrypterInputStream
extends FilterInputStream {
    public static final int MAGIC_BYTE = 60;
    private final Header header;
    private final Cipher cipher;
    private byte[] readBuffer;
    private byte[] cipherBuffer;
    private boolean cipherFinalized;
    private final byte[] singleByteArray = new byte[1];
    private int cipherBufferReadOff = 0;
    private int cipherBufferUsedLen = 0;
    private boolean closed;
    private boolean closeUnderlyingStream = true;

    public DecrypterInputStream(InputStream in, CipherParameters key) throws IOException {
        super(Objects.requireNonNull(in, "in"));
        this.header = this.readHeader();
        EncrypterDecrypterStreamUtil.assertValidKey(this.header.cipherTransformation, key);
        this.cipher = this.createCipher();
        Object cipherParameters = this.header.iv == null ? key : new ParametersWithIV(key, this.header.iv);
        this.cipher.init(CipherOperationMode.DECRYPT, cipherParameters);
    }

    private Cipher createCipher() {
        try {
            return CryptoRegistry.getInstance().createCipher(this.header.cipherTransformation.getTransformation());
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    private Header readHeader() throws IOException {
        byte[] iv;
        int magicByte = this.in.read();
        if (60 != magicByte) {
            throw new IOException(String.format("First byte from input does not match expected magic number! expected=%s found=%s", 60, magicByte));
        }
        int version = this.in.read();
        if (version != 1) {
            throw new IOException("version != 1 :: version == " + version);
        }
        int cipherTransformationNumeric = this.readOrFail() + (this.readOrFail() << 8);
        if (cipherTransformationNumeric > CipherTransformation.values().length) {
            throw new IOException(String.format("cipherTransformationNumeric > CipherTransformation.values().length :: %s > %s", cipherTransformationNumeric, CipherTransformation.values().length));
        }
        CipherTransformation cipherTransformation = CipherTransformation.values()[cipherTransformationNumeric];
        int ivLength = this.readOrFail() + (this.readOrFail() << 8);
        if (ivLength < 0) {
            throw new IOException("ivLength < 0");
        }
        if (ivLength == 0) {
            iv = null;
        } else {
            iv = new byte[ivLength];
            this.readOrFail(iv, 0, ivLength);
        }
        return new Header(version, cipherTransformation, iv);
    }

    public byte[] getIv() {
        return this.header.iv;
    }

    @Override
    public int read() throws IOException {
        int bytesRead;
        this.assertNotClosed();
        while ((bytesRead = this.read(this.singleByteArray, 0, this.singleByteArray.length)) == 0) {
        }
        if (bytesRead < 0) {
            return -1;
        }
        return this.singleByteArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.assertNotClosed();
        if (len == 0) {
            return 0;
        }
        int readFromCipherBuffer = this.readFromCipherBuffer(b, off, len);
        if (readFromCipherBuffer > 0) {
            return readFromCipherBuffer;
        }
        int consecutiveEmptyReadCount = 0;
        do {
            if (this.cipherFinalized) {
                return -1;
            }
            this.ensureReadBufferMinLength(len);
            int bytesRead = this.in.read(this.readBuffer, 0, len);
            if (bytesRead == 0) {
                if (++consecutiveEmptyReadCount > 5) {
                    throw new IOException(String.format("Encountered %s consecutive empty read operations (but no end-of-stream)!", consecutiveEmptyReadCount));
                }
            } else {
                int bytesWritten;
                consecutiveEmptyReadCount = 0;
                if (bytesRead > 0) {
                    this.ensureCipherBufferMinLength(this.cipher.getOutputSize(bytesRead));
                }
                this.cipherBufferReadOff = 0;
                this.cipherBufferUsedLen = 0;
                try {
                    if (bytesRead > 0) {
                        bytesWritten = this.cipher.update(this.readBuffer, 0, bytesRead, this.cipherBuffer, 0);
                    } else {
                        this.cipherFinalized = true;
                        bytesWritten = this.cipher.doFinal(this.cipherBuffer, 0);
                    }
                }
                catch (IllegalStateException | CryptoException | DataLengthException e) {
                    throw new IOException(e);
                }
                if (bytesWritten > 0) {
                    this.cipherBufferUsedLen += bytesWritten;
                }
            }
            if ((readFromCipherBuffer = this.readFromCipherBuffer(b, off, len)) > 0 || bytesRead >= 0) continue;
            return -1;
        } while (readFromCipherBuffer <= 0);
        return readFromCipherBuffer;
    }

    protected int readFromCipherBuffer(byte[] b, int off, int len) throws IOException {
        if (this.cipherBufferUsedLen > 0) {
            int length = Math.min(len, this.cipherBufferUsedLen);
            System.arraycopy(this.cipherBuffer, this.cipherBufferReadOff, b, off, length);
            this.cipherBufferReadOff += length;
            this.cipherBufferUsedLen -= length;
            if (this.cipherBufferUsedLen < 0) {
                throw new IllegalStateException("cipherBufferUsedLen < 0");
            }
            if (this.cipherBufferUsedLen == 0) {
                this.cipherBufferReadOff = 0;
            }
            return length;
        }
        return 0;
    }

    @Override
    public long skip(long n) throws IOException {
        int len;
        int bytesRead;
        this.assertNotClosed();
        if (n <= 0L) {
            return 0L;
        }
        byte[] buffer = new byte[(int)Math.min(n, 16384L)];
        long bytesToSkip = n;
        while (bytesToSkip > 0L && (bytesRead = this.read(buffer, 0, len = (int)Math.min(bytesToSkip, (long)buffer.length))) >= 0) {
            if ((bytesToSkip -= (long)bytesRead) >= 0L) continue;
            throw new IllegalStateException("bytesToSkip < 0");
        }
        return n - bytesToSkip;
    }

    @Override
    public int available() throws IOException {
        this.assertNotClosed();
        int cipherOutputSize = this.cipher.getOutputSize(0);
        if (this.cipherBufferUsedLen > 0) {
            return this.cipherBufferUsedLen;
        }
        if (cipherOutputSize > 0) {
            return cipherOutputSize;
        }
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.isCloseUnderlyingStream()) {
                this.in.close();
            }
        }
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public boolean isCloseUnderlyingStream() {
        return this.closeUnderlyingStream;
    }

    public void setCloseUnderlyingStream(boolean closeUnderlyingStream) {
        this.closeUnderlyingStream = closeUnderlyingStream;
    }

    private void ensureCipherBufferMinLength(int minLength) {
        if (minLength < 0) {
            throw new IllegalArgumentException("minLength < 0");
        }
        if (this.cipherBuffer == null || this.cipherBuffer.length < minLength) {
            this.cipherBuffer = new byte[minLength];
        }
    }

    private void ensureReadBufferMinLength(int minLength) {
        if (minLength <= 0) {
            throw new IllegalArgumentException("minLength <= 0");
        }
        if (this.readBuffer == null || this.readBuffer.length < minLength) {
            this.readBuffer = new byte[minLength];
        }
    }

    private int readOrFail() throws IOException {
        return IOUtil.readOrFail((InputStream)this.in);
    }

    private void readOrFail(byte[] buf, int off, int len) throws IOException {
        IOUtil.readOrFail((InputStream)this.in, (byte[])buf, (int)off, (int)len);
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("DecrypterInputStream already closed!");
        }
    }

    protected static class Header {
        public final int version;
        public final CipherTransformation cipherTransformation;
        public final byte[] iv;

        public Header(int version, CipherTransformation cipherTransformation, byte[] iv) {
            this.version = version;
            this.cipherTransformation = Objects.requireNonNull(cipherTransformation, "cipherTransformation");
            this.iv = iv;
        }
    }
}

