/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp.sync;

import java.util.Objects;
import org.subshare.core.pgp.sync.PgpSync;
import org.subshare.core.pgp.sync.PgpSyncDaemon;
import org.subshare.core.server.Server;
import org.subshare.core.sync.Sync;
import org.subshare.core.sync.SyncDaemonImpl;

public class PgpSyncDaemonImpl
extends SyncDaemonImpl
implements PgpSyncDaemon {
    public static final String CONFIG_KEY_PGP_SYNC_PERIOD = "pgpSyncPeriod";
    public static final long CONFIG_DEFAULT_VALUE_PGP_SYNC_PERIOD = 3600000L;

    @Override
    protected String getConfigKeySyncPeriod() {
        return CONFIG_KEY_PGP_SYNC_PERIOD;
    }

    @Override
    protected long getConfigDefaultValueSyncPeriod() {
        return 3600000L;
    }

    @Override
    protected Sync createSync(Server server) {
        Objects.requireNonNull(server, "server");
        return new PgpSync(server);
    }

    public static PgpSyncDaemon getInstance() {
        return Holder.instance;
    }

    private static final class Holder {
        public static final PgpSyncDaemonImpl instance = new PgpSyncDaemonImpl();

        private Holder() {
        }
    }
}

