/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp.transport.local;

import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.IOutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.subshare.core.pgp.Pgp;
import org.subshare.core.pgp.PgpKey;
import org.subshare.core.pgp.PgpKeyId;
import org.subshare.core.pgp.PgpRegistry;
import org.subshare.core.pgp.transport.AbstractPgpTransport;

public class LocalPgpTransport
extends AbstractPgpTransport {
    private final Pgp pgp = PgpRegistry.getInstance().getPgpOrFail();

    @Override
    public long getLocalRevision() {
        return this.pgp.getLocalRevision();
    }

    @Override
    public Set<PgpKeyId> getMasterKeyIds() {
        Collection<PgpKey> masterKeys = this.pgp.getMasterKeys();
        HashSet<PgpKeyId> pgpKeyIds = new HashSet<PgpKeyId>(masterKeys.size());
        for (PgpKey pgpKey : masterKeys) {
            pgpKeyIds.add(pgpKey.getPgpKeyId());
        }
        return pgpKeyIds;
    }

    @Override
    public void exportPublicKeys(Set<PgpKeyId> pgpKeyIds, long changedAfterLocalRevision, IOutputStream out) {
        Objects.requireNonNull(pgpKeyIds, "pgpKeyIds");
        Objects.requireNonNull(out, "out");
        HashSet<PgpKey> masterKeys = new HashSet<PgpKey>(pgpKeyIds.size());
        for (PgpKeyId pgpKeyId : pgpKeyIds) {
            long localRevision;
            PgpKey masterKey = this.pgp.getPgpKey(pgpKeyId);
            if (masterKey == null || (localRevision = this.pgp.getLocalRevision(masterKey)) <= changedAfterLocalRevision) continue;
            masterKeys.add(masterKey);
        }
        this.pgp.exportPublicKeys(masterKeys, out);
    }

    @Override
    public void exportPublicKeysMatchingQuery(String queryString, IOutputStream out) {
        Objects.requireNonNull(queryString, "queryString");
        Objects.requireNonNull(out, "out");
        HashSet<PgpKey> masterKeys = new HashSet<PgpKey>();
        String userId = queryString.trim().toLowerCase();
        String emailWithSeparators = this.appendEmailSeparators(userId.toLowerCase());
        for (PgpKey masterKey : this.pgp.getMasterKeys()) {
            if (!this.matches(masterKey, userId, emailWithSeparators)) continue;
            masterKeys.add(masterKey);
        }
        this.pgp.exportPublicKeys(masterKeys, out);
    }

    private String appendEmailSeparators(String email) {
        email = Objects.requireNonNull(email, "email").trim();
        StringBuilder sb = new StringBuilder(email.length() + 2);
        if (!email.startsWith("<")) {
            sb.append('<');
        }
        sb.append(email);
        if (!email.endsWith(">")) {
            sb.append('>');
        }
        return sb.toString();
    }

    private boolean matches(PgpKey pgpKey, String searchedUserId, String searchedEmailWithSeparators) {
        Objects.requireNonNull(pgpKey, "pgpKey");
        Objects.requireNonNull(searchedUserId, "searchedUserId");
        Objects.requireNonNull(searchedEmailWithSeparators, "searchedEmailWithSeparators");
        for (String userId : pgpKey.getUserIds()) {
            String userIdLowerCase = userId.toLowerCase();
            if (!userIdLowerCase.equals(searchedUserId) && !userIdLowerCase.contains(searchedEmailWithSeparators)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void importKeys(IInputStream in) {
        this.pgp.importKeys(in);
    }
}

