/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.server;

import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistry;
import co.codewizards.cloudstore.core.repo.local.LocalRepoRegistryImpl;
import co.codewizards.cloudstore.local.RepairDatabase;
import co.codewizards.cloudstore.ls.server.LocalServer;
import co.codewizards.cloudstore.server.CloudStoreServer;
import java.util.UUID;
import org.eclipse.jetty.server.Server;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.ls.server.SsLocalServer;
import org.subshare.rest.server.SubShareRest;

public class SubShareServer
extends CloudStoreServer {
    private static final Logger logger = LoggerFactory.getLogger(SubShareServer.class);

    public static void main(String[] args) throws Exception {
        SubShareServer.setCloudStoreServerClass(SubShareServer.class);
        CloudStoreServer.main(args);
    }

    public SubShareServer(String ... args) {
        super(args);
    }

    @Override
    protected LocalServer createLocalServer() {
        return new SsLocalServer();
    }

    @Override
    protected ResourceConfig createResourceConfig() {
        return new SubShareRest();
    }

    @Override
    protected Server createServer() {
        this.repairIfNeeded();
        return super.createServer();
    }

    protected void repairIfNeeded() {
        try {
            LocalRepoRegistry localRepoRegistry = LocalRepoRegistryImpl.getInstance();
            for (UUID repositoryId : localRepoRegistry.getRepositoryIds()) {
                boolean repairEnabled;
                logger.info("repairIfNeeded: repositoryId={}", (Object)repositoryId);
                File localRoot = localRepoRegistry.getLocalRoot(repositoryId);
                if (localRoot == null) {
                    logger.warn("repairIfNeeded: repositoryId={}: localRoot not found!", (Object)repositoryId);
                    continue;
                }
                File repairTriggerFile = OioFileFactory.createFile((File)localRoot, (String[])new String[]{LocalRepoManager.META_DIR_NAME}).createFile(new String[]{"repair.deleteToRun"});
                boolean bl = repairEnabled = !repairTriggerFile.exists();
                if (repairEnabled) {
                    logger.info("repairIfNeeded: repositoryId={}, repairTriggerFile='{}' does not exist! Creating this file and beginning repair now.", (Object)repositoryId, (Object)repairTriggerFile.getAbsolutePath());
                    try {
                        repairTriggerFile.createOutputStream().close();
                        new RepairDatabase(localRoot).run();
                        LocalRepoManager localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(localRoot);
                        localRepoManager.close();
                        logger.info("repairIfNeeded: repositoryId={}: Repair completed.", (Object)repositoryId);
                    }
                    catch (Exception x) {
                        logger.error("repairIfNeeded: repositoryId=" + repositoryId + ": " + x, (Throwable)x);
                    }
                    continue;
                }
                logger.info("repairIfNeeded: repositoryId={}, repairTriggerFile='{}' exists! Skipping repair.", (Object)repositoryId, (Object)repairTriggerFile.getAbsolutePath());
            }
        }
        catch (Exception x) {
            logger.error("repairIfNeeded: " + x, (Throwable)x);
        }
    }
}

