/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.core.dto.jaxb.RepoFileDtoIo;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.local.persistence.RepoFile;
import co.codewizards.cloudstore.local.persistence.RepoFileDao;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.subshare.core.dto.jaxb.CollisionPrivateDtoIo;
import org.subshare.core.sign.SignableSigner;
import org.subshare.core.sign.SignableVerifier;
import org.subshare.core.user.UserRegistry;
import org.subshare.core.user.UserRegistryImpl;
import org.subshare.core.user.UserRepoKey;
import org.subshare.core.user.UserRepoKeyPublicKeyLookup;
import org.subshare.core.user.UserRepoKeyRing;
import org.subshare.local.CryptreeNode;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.CryptoRepoFileDao;
import org.subshare.local.persistence.RepositoryOwner;
import org.subshare.local.persistence.RepositoryOwnerDao;
import org.subshare.local.persistence.UserRepoKeyPublicKeyLookupImpl;

public class CryptreeContext {
    public final UserRepoKeyRing userRepoKeyRing;
    public final LocalRepoTransaction transaction;
    public final UUID localRepositoryId;
    public final UUID remoteRepositoryId;
    public final UUID serverRepositoryId;
    public final String remotePathPrefix;
    public final boolean isOnServer;
    public final RepoFileDtoIo repoFileDtoIo;
    public final CollisionPrivateDtoIo collisionPrivateDtoIo;
    public final SignableVerifier signableVerifier;
    private RepositoryOwner repositoryOwner;
    private final Map<UserRepoKey, SignableSigner> userRepoKey2SignableSigner = new HashMap<UserRepoKey, SignableSigner>();
    private final Map<String, CryptreeNode> localPath2CryptreeNode = new HashMap<String, CryptreeNode>();
    private final Map<Uid, CryptreeNode> cryptoRepoFileId2CryptreeNode = new HashMap<Uid, CryptreeNode>();
    private Uid cryptoRepoFileIdForRemotePathPrefix;

    public CryptreeContext(UserRepoKeyRing userRepoKeyRing, LocalRepoTransaction transaction, UUID localRepositoryId, UUID remoteRepositoryId, UUID serverRepositoryId, String remotePathPrefix, boolean isOnServer) {
        if (!isOnServer) {
            Objects.requireNonNull(userRepoKeyRing, "userRepoKeyRing");
            Objects.requireNonNull(remotePathPrefix, "remotePathPrefix");
        }
        this.userRepoKeyRing = userRepoKeyRing;
        this.transaction = Objects.requireNonNull(transaction, "transaction");
        this.localRepositoryId = Objects.requireNonNull(localRepositoryId, "localRepositoryId");
        this.remoteRepositoryId = Objects.requireNonNull(remoteRepositoryId, "remoteRepositoryId");
        this.serverRepositoryId = Objects.requireNonNull(serverRepositoryId, "serverRepositoryId");
        this.remotePathPrefix = remotePathPrefix;
        this.isOnServer = isOnServer;
        this.repoFileDtoIo = new RepoFileDtoIo();
        this.collisionPrivateDtoIo = new CollisionPrivateDtoIo();
        this.signableVerifier = new SignableVerifier((UserRepoKeyPublicKeyLookup)new UserRepoKeyPublicKeyLookupImpl(transaction));
        if (userRepoKeyRing != null && userRepoKeyRing.getPermanentUserRepoKeys(serverRepositoryId).isEmpty()) {
            throw new IllegalArgumentException(String.format("userRepoKeyRing.getUserRepoKeys(serverRepositoryId).isEmpty() :: serverRepositoryId=%s", serverRepositoryId));
        }
    }

    public UserRegistry getUserRegistry() {
        return UserRegistryImpl.getInstance();
    }

    public CryptreeNode getCryptreeNodeOrCreate(String localPath) {
        CryptreeNode cryptreeNode;
        Objects.requireNonNull(localPath, "localPath");
        if ("/".equals(localPath)) {
            localPath = "";
        }
        if ((cryptreeNode = this.localPath2CryptreeNode.get(localPath)) == null) {
            cryptreeNode = this.createCryptreeNodeOrFail(localPath);
            this.localPath2CryptreeNode.put(localPath, cryptreeNode);
        }
        return cryptreeNode;
    }

    public CryptreeNode getCryptreeNodeOrCreate(Uid cryptoRepoFileId) {
        Objects.requireNonNull(cryptoRepoFileId, "cryptoRepoFileId");
        CryptreeNode cryptreeNode = this.cryptoRepoFileId2CryptreeNode.get(cryptoRepoFileId);
        if (cryptreeNode == null) {
            cryptreeNode = this.createCryptreeNodeOrFail(cryptoRepoFileId);
            this.cryptoRepoFileId2CryptreeNode.put(cryptoRepoFileId, cryptreeNode);
        }
        return cryptreeNode;
    }

    public void registerCryptreeNode(RepoFile repoFile, CryptreeNode cryptreeNode) {
        Objects.requireNonNull(repoFile, "repoFile");
        Objects.requireNonNull(cryptreeNode, "cryptreeNode");
        this.localPath2CryptreeNode.put(repoFile.getPath(), cryptreeNode);
    }

    public void registerCryptreeNode(CryptoRepoFile cryptoRepoFile, CryptreeNode cryptreeNode) {
        Objects.requireNonNull(cryptoRepoFile, "cryptoRepoFile");
        Objects.requireNonNull(cryptreeNode, "cryptreeNode");
        this.cryptoRepoFileId2CryptreeNode.put(cryptoRepoFile.getCryptoRepoFileId(), cryptreeNode);
    }

    public CryptreeNode getCryptreeNodeOrCreate(CryptreeNode parent, CryptreeNode child, RepoFile repoFile, CryptoRepoFile cryptoRepoFile) {
        CryptreeNode cryptreeNode = null;
        String localPath = null;
        if (repoFile != null) {
            localPath = repoFile.getPath();
            cryptreeNode = this.localPath2CryptreeNode.get(localPath);
        }
        if (cryptreeNode != null) {
            return cryptreeNode;
        }
        Uid cryptoRepoFileId = null;
        if (cryptoRepoFile != null) {
            cryptoRepoFileId = cryptoRepoFile.getCryptoRepoFileId();
            cryptreeNode = this.cryptoRepoFileId2CryptreeNode.get(cryptoRepoFileId);
        }
        if (cryptreeNode != null) {
            return cryptreeNode;
        }
        cryptreeNode = new CryptreeNode(parent, child, this, repoFile, cryptoRepoFile);
        if (localPath != null) {
            this.localPath2CryptreeNode.put(localPath, cryptreeNode);
        }
        if (cryptoRepoFileId != null) {
            this.cryptoRepoFileId2CryptreeNode.put(cryptoRepoFileId, cryptreeNode);
        }
        return cryptreeNode;
    }

    public RepositoryOwner getRepositoryOwnerOrFail() {
        if (this.repositoryOwner == null) {
            RepositoryOwnerDao roDao = (RepositoryOwnerDao)((Object)this.transaction.getDao(RepositoryOwnerDao.class));
            this.repositoryOwner = roDao.getRepositoryOwnerOrFail(this.serverRepositoryId);
        }
        return this.repositoryOwner;
    }

    public RepositoryOwner getRepositoryOwner() {
        if (this.repositoryOwner == null) {
            RepositoryOwnerDao roDao = (RepositoryOwnerDao)((Object)this.transaction.getDao(RepositoryOwnerDao.class));
            this.repositoryOwner = roDao.getRepositoryOwner(this.serverRepositoryId);
        }
        return this.repositoryOwner;
    }

    public SignableSigner getSignableSigner(UserRepoKey userRepoKey) {
        Objects.requireNonNull(userRepoKey, "userRepoKey");
        SignableSigner signableSigner = this.userRepoKey2SignableSigner.get(userRepoKey);
        if (signableSigner == null) {
            signableSigner = new SignableSigner(userRepoKey);
            this.userRepoKey2SignableSigner.put(userRepoKey, signableSigner);
        }
        return signableSigner;
    }

    private CryptreeNode createCryptreeNodeOrFail(String localPath) {
        RepoFile repoFile = this.getRepoFile(localPath);
        if (repoFile != null) {
            CryptreeNode cryptreeNode = new CryptreeNode(this, repoFile);
            return cryptreeNode;
        }
        CryptoRepoFile cryptoRepoFile = this.getCryptoRepoFileOrFail(localPath);
        CryptreeNode cryptreeNode = new CryptreeNode(this, cryptoRepoFile);
        return cryptreeNode;
    }

    private CryptreeNode createCryptreeNodeOrFail(Uid cryptoRepoFileId) {
        CryptoRepoFile cryptoRepoFile = this.getCryptoRepoFileOrFail(cryptoRepoFileId);
        CryptreeNode cryptreeNode = new CryptreeNode(this, cryptoRepoFile);
        return cryptreeNode;
    }

    public CryptoRepoFile getCryptoRepoFileOrFail(Uid cryptoRepoFileId) {
        CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)this.transaction.getDao(CryptoRepoFileDao.class));
        CryptoRepoFile cryptoRepoFile = cryptoRepoFileDao.getCryptoRepoFileOrFail(cryptoRepoFileId);
        return cryptoRepoFile;
    }

    public CryptoRepoFile getCryptoRepoFileOrFail(String localPath) {
        CryptoRepoFile cryptoRepoFile = this.getCryptoRepoFile(localPath);
        Objects.requireNonNull(cryptoRepoFile, "cryptoRepoFile");
        return cryptoRepoFile;
    }

    public CryptoRepoFile getCryptoRepoFile(String localPath) {
        CryptoRepoFileDao cryptoRepoFileDao = (CryptoRepoFileDao)((Object)this.transaction.getDao(CryptoRepoFileDao.class));
        CryptoRepoFile cryptoRepoFile = cryptoRepoFileDao.getCryptoRepoFile(this.prefixLocalPath(localPath));
        return cryptoRepoFile;
    }

    private String prefixLocalPath(String localPath) {
        Objects.requireNonNull(localPath, "localPath");
        if (this.remotePathPrefix.isEmpty()) {
            return localPath;
        }
        CryptoRepoFile prefixCryptoRepoFile = this.getCryptoRepoFileForRemotePathPrefixOrFail();
        if (localPath.isEmpty()) {
            return prefixCryptoRepoFile.getLocalPathOrFail();
        }
        if ("/".equals(localPath)) {
            throw new IllegalStateException("localPath should never be '/', but instead it should be an empty String, if the real root is checked out!");
        }
        if (!localPath.startsWith("/")) {
            throw new IllegalStateException(String.format("localPath '%s' is neither empty nor does it start with '/'!", localPath));
        }
        String prefix = prefixCryptoRepoFile.getLocalPathOrFail();
        if (!prefix.isEmpty() && !prefix.startsWith("/")) {
            throw new IllegalStateException(String.format("prefixCryptoRepoFile.localPath '%s' is neither empty nor does it start with '/'!", prefix));
        }
        if (prefix.endsWith("/")) {
            throw new IllegalStateException(String.format("prefixCryptoRepoFile.localPath '%s' ends with '/'! It should not!", prefix));
        }
        return prefix + localPath;
    }

    private CryptoRepoFile getCryptoRepoFileForRemotePathPrefixOrFail() {
        Uid id = this.getCryptoRepoFileIdForRemotePathPrefixOrFail();
        CryptoRepoFile prefixCryptoRepoFile = this.getCryptoRepoFileOrFail(id);
        return prefixCryptoRepoFile;
    }

    public Uid getCryptoRepoFileIdForRemotePathPrefixOrFail() {
        if (this.cryptoRepoFileIdForRemotePathPrefix == null) {
            if (this.isOnServer) {
                throw new IllegalStateException("This method cannot be used on the server!");
            }
            if (this.remotePathPrefix.isEmpty()) {
                throw new IllegalStateException("This method cannot be used, if there is no remotePathPrefix!");
            }
            if ("/".equals(this.remotePathPrefix)) {
                throw new IllegalStateException("The remotePathPrefix should be an empty string, if the root is checked out!");
            }
            int lastSlashIndex = this.remotePathPrefix.lastIndexOf(47);
            String uidStr = lastSlashIndex < 0 ? this.remotePathPrefix : this.remotePathPrefix.substring(lastSlashIndex + 1);
            this.cryptoRepoFileIdForRemotePathPrefix = new Uid(uidStr);
        }
        return this.cryptoRepoFileIdForRemotePathPrefix;
    }

    private RepoFile getRepoFile(String localPath) {
        LocalRepoManager localRepoManager = this.transaction.getLocalRepoManager();
        RepoFileDao repoFileDao = (RepoFileDao)this.transaction.getDao(RepoFileDao.class);
        RepoFile repoFile = repoFileDao.getRepoFile(localRepoManager.getLocalRoot(), OioFileFactory.createFile((File)localRepoManager.getLocalRoot(), (String[])new String[]{localPath}));
        return repoFile;
    }
}

