/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local;

import java.util.Objects;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.crypto.KeyFactory;
import org.subshare.core.dto.CryptoKeyPart;
import org.subshare.core.dto.CryptoKeyRole;
import org.subshare.core.dto.CryptoKeyType;
import org.subshare.core.dto.PermissionType;
import org.subshare.core.user.UserRepoKey;
import org.subshare.crypto.CipherOperationMode;
import org.subshare.local.CryptreeContext;
import org.subshare.local.CryptreeNode;
import org.subshare.local.CryptreeNodeUtil;
import org.subshare.local.PlainCryptoKey;
import org.subshare.local.persistence.CryptoKey;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.PermissionDao;
import org.subshare.local.persistence.PermissionSet;
import org.subshare.local.persistence.PermissionSetInheritance;
import org.subshare.local.persistence.UserRepoKeyPublicKey;

abstract class PlainCryptoKeyFactory {
    private CryptreeNode cryptreeNode;
    private CipherOperationMode cipherOperationMode;

    PlainCryptoKeyFactory() {
    }

    public CryptreeNode getCryptreeNode() {
        return this.cryptreeNode;
    }

    public void setCryptreeNode(CryptreeNode cryptreeNode) {
        this.cryptreeNode = cryptreeNode;
    }

    public CryptreeNode getCryptreeNodeOrFail() {
        CryptreeNode cryptreeNode = this.getCryptreeNode();
        return Objects.requireNonNull(cryptreeNode, "cryptreeNode");
    }

    public CipherOperationMode getCipherOperationMode() {
        return this.cipherOperationMode;
    }

    public void setCipherOperationMode(CipherOperationMode cipherOperationMode) {
        this.cipherOperationMode = cipherOperationMode;
    }

    public CipherOperationMode getCipherOperationModeOrFail() {
        CipherOperationMode cipherOperationMode = this.getCipherOperationMode();
        return Objects.requireNonNull(cipherOperationMode, "cipherOperationMode");
    }

    public CryptreeContext getContext() {
        return this.cryptreeNode == null ? null : this.cryptreeNode.getContext();
    }

    public CryptreeContext getContextOrFail() {
        CryptreeContext context = this.getContext();
        return Objects.requireNonNull(context, "context");
    }

    public abstract PlainCryptoKey createPlainCryptoKey();

    protected CryptoKey createCryptoKey(CryptoKeyRole cryptoKeyRole, CryptoKeyType cryptoKeyType) {
        Objects.requireNonNull(cryptoKeyRole, "cryptoKeyRole");
        Objects.requireNonNull(cryptoKeyType, "cryptoKeyType");
        CryptoKey cryptoKey = new CryptoKey();
        cryptoKey.setCryptoRepoFile(this.getCryptreeNodeOrFail().getCryptoRepoFile());
        cryptoKey.setCryptoKeyRole(cryptoKeyRole);
        cryptoKey.setCryptoKeyType(cryptoKeyType);
        cryptoKey.setLastSyncFromRepositoryId(null);
        this.getCryptreeNodeOrFail().sign(cryptoKey);
        return cryptoKey;
    }

    protected PlainCryptoKey createSymmetricPlainCryptoKey(CryptoKeyRole cryptoKeyRole) {
        Objects.requireNonNull(cryptoKeyRole, "cryptoKeyRole");
        KeyParameter keyParameter = KeyFactory.getInstance().createSymmetricKey();
        CryptoKey cryptoKey = this.createCryptoKey(cryptoKeyRole, CryptoKeyType.symmetric);
        PlainCryptoKey plainCryptoKey = new PlainCryptoKey(cryptoKey, CryptoKeyPart.sharedSecret, (CipherParameters)keyParameter);
        return plainCryptoKey;
    }

    static class DataKeyPlainCryptoKeyFactory
    extends PlainCryptoKeyFactory {
        private static final Logger logger = LoggerFactory.getLogger(DataKeyPlainCryptoKeyFactory.class);

        DataKeyPlainCryptoKeyFactory() {
        }

        @Override
        public PlainCryptoKey createPlainCryptoKey() {
            CryptreeNode cryptreeNode = this.getCryptreeNodeOrFail();
            logger.debug("createPlainCryptoKey: >>> cryptoRepoFile={} repoFile={}", (Object)cryptreeNode.getCryptoRepoFile(), (Object)cryptreeNode.getRepoFile());
            PlainCryptoKey plainCryptoKey = this.createSymmetricPlainCryptoKey(CryptoKeyRole.dataKey);
            this.createCryptoLinkFromBacklinkKey(plainCryptoKey);
            this.createCryptoLinkFromParentFileKey(plainCryptoKey);
            logger.debug("createPlainCryptoKey: <<< cryptoRepoFile={} repoFile={}", (Object)cryptreeNode.getCryptoRepoFile(), (Object)cryptreeNode.getRepoFile());
            return plainCryptoKey;
        }

        private void createCryptoLinkFromBacklinkKey(PlainCryptoKey toPlainCryptoKey) {
            Objects.requireNonNull(toPlainCryptoKey, "toPlainCryptoKey");
            CryptreeNode cryptreeNode = this.getCryptreeNodeOrFail();
            PlainCryptoKey backlinkKeyPlainCryptoKey = cryptreeNode.isDirectory() ? cryptreeNode.getActivePlainCryptoKeyOrCreate(CryptoKeyRole.backlinkKey, CipherOperationMode.ENCRYPT) : cryptreeNode.getActivePlainCryptoKey(CryptoKeyRole.backlinkKey, CipherOperationMode.ENCRYPT);
            if (backlinkKeyPlainCryptoKey != null) {
                CryptreeNodeUtil.createCryptoLink(cryptreeNode, backlinkKeyPlainCryptoKey, toPlainCryptoKey);
            }
        }

        private void createCryptoLinkFromParentFileKey(PlainCryptoKey toPlainCryptoKey) {
            Objects.requireNonNull(toPlainCryptoKey, "toPlainCryptoKey");
            CryptreeNode cryptreeNode = this.getCryptreeNodeOrFail();
            if (cryptreeNode.isDirectory()) {
                return;
            }
            CryptreeNode parent = cryptreeNode.getParent();
            if (parent == null) {
                throw new IllegalStateException("cryptreeNode is *not* a directory, but parent == null !!!");
            }
            PlainCryptoKey fileKeyPlainCryptoKey = parent.getActivePlainCryptoKeyOrCreate(CryptoKeyRole.fileKey, CipherOperationMode.ENCRYPT);
            CryptreeNodeUtil.createCryptoLink(cryptreeNode, fileKeyPlainCryptoKey, toPlainCryptoKey);
        }
    }

    static class BacklinkKeyPlainCryptoKeyFactory
    extends PlainCryptoKeyFactory {
        private static final Logger logger = LoggerFactory.getLogger(BacklinkKeyPlainCryptoKeyFactory.class);

        BacklinkKeyPlainCryptoKeyFactory() {
        }

        @Override
        public PlainCryptoKey createPlainCryptoKey() {
            CryptreeNode cryptreeNode = this.getCryptreeNodeOrFail();
            logger.debug("createPlainCryptoKey: >>> cryptoRepoFile={} repoFile={}", (Object)cryptreeNode.getCryptoRepoFile(), (Object)cryptreeNode.getRepoFile());
            PlainCryptoKey plainCryptoKey = this.createSymmetricPlainCryptoKey(CryptoKeyRole.backlinkKey);
            this.createCryptoLinkFromSubdirKey(plainCryptoKey);
            for (CryptreeNode child : cryptreeNode.getChildren()) {
                this.createCryptoLinkFromChildBacklinkKey(child, plainCryptoKey);
            }
            this.createCryptoLinkToParentBacklinkKey(plainCryptoKey);
            logger.debug("createPlainCryptoKey: <<< cryptoRepoFile={} repoFile={}", (Object)cryptreeNode.getCryptoRepoFile(), (Object)cryptreeNode.getRepoFile());
            return plainCryptoKey;
        }

        private void createCryptoLinkToParentBacklinkKey(PlainCryptoKey fromPlainCryptoKey) {
            PlainCryptoKey parentBacklinkKeyPlainCryptoKey;
            Objects.requireNonNull(fromPlainCryptoKey, "fromPlainCryptoKey");
            CryptreeNode cryptreeNode = this.getCryptreeNodeOrFail();
            CryptreeNode parent = cryptreeNode.getParent();
            if (parent != null && (parentBacklinkKeyPlainCryptoKey = parent.getActivePlainCryptoKey(CryptoKeyRole.backlinkKey, CipherOperationMode.DECRYPT)) != null) {
                CryptreeNodeUtil.createCryptoLink(parent, fromPlainCryptoKey, parentBacklinkKeyPlainCryptoKey);
            }
        }

        private void createCryptoLinkFromSubdirKey(PlainCryptoKey toPlainCryptoKey) {
            Objects.requireNonNull(toPlainCryptoKey, "toPlainCryptoKey");
            CryptreeNode cryptreeNode = this.getCryptreeNodeOrFail();
            if (!cryptreeNode.isDirectory()) {
                return;
            }
            PlainCryptoKey subdirKeyPlainCryptoKey = cryptreeNode.getActivePlainCryptoKeyOrCreate(CryptoKeyRole.subdirKey, CipherOperationMode.ENCRYPT);
            CryptreeNodeUtil.createCryptoLink(cryptreeNode, subdirKeyPlainCryptoKey, toPlainCryptoKey);
        }

        private void createCryptoLinkFromChildBacklinkKey(CryptreeNode fromChild, PlainCryptoKey toPlainCryptoKey) {
            Objects.requireNonNull(fromChild, "fromChild");
            Objects.requireNonNull(toPlainCryptoKey, "toPlainCryptoKey");
            PlainCryptoKey childBacklinkKeyPlainCryptoKey = fromChild.getActivePlainCryptoKeyOrCreate(CryptoKeyRole.backlinkKey, CipherOperationMode.ENCRYPT);
            CryptreeNodeUtil.createCryptoLink(this.getCryptreeNodeOrFail(), childBacklinkKeyPlainCryptoKey, toPlainCryptoKey);
        }
    }

    static class FileKeyPlainCryptoKeyFactory
    extends PlainCryptoKeyFactory {
        private static final Logger logger = LoggerFactory.getLogger(FileKeyPlainCryptoKeyFactory.class);

        FileKeyPlainCryptoKeyFactory() {
        }

        @Override
        public PlainCryptoKey createPlainCryptoKey() {
            CryptreeNode cryptreeNode = this.getCryptreeNodeOrFail();
            logger.debug("createPlainCryptoKey: >>> cryptoRepoFile={} repoFile={}", (Object)cryptreeNode.getCryptoRepoFile(), (Object)cryptreeNode.getRepoFile());
            if (!cryptreeNode.isDirectory()) {
                throw new IllegalStateException("Cannot create a fileKey, because this CryptreeNode is *not* a directory!");
            }
            PlainCryptoKey plainCryptoKey = this.createSymmetricPlainCryptoKey(CryptoKeyRole.fileKey);
            this.createCryptoLinkFromSubdirKey(plainCryptoKey);
            for (CryptreeNode child : cryptreeNode.getChildren()) {
                this.createCryptoLinkToChildDataKey(plainCryptoKey, child);
            }
            logger.debug("createPlainCryptoKey: <<< cryptoRepoFile={} repoFile={}", (Object)cryptreeNode.getCryptoRepoFile(), (Object)cryptreeNode.getRepoFile());
            return plainCryptoKey;
        }

        private void createCryptoLinkFromSubdirKey(PlainCryptoKey toPlainCryptoKey) {
            Objects.requireNonNull(toPlainCryptoKey, "toPlainCryptoKey");
            CryptreeNode cryptreeNode = this.getCryptreeNodeOrFail();
            PlainCryptoKey subdirKeyPlainCryptoKey = cryptreeNode.getActivePlainCryptoKeyOrCreate(CryptoKeyRole.subdirKey, CipherOperationMode.ENCRYPT);
            CryptreeNodeUtil.createCryptoLink(cryptreeNode, subdirKeyPlainCryptoKey, toPlainCryptoKey);
        }

        private void createCryptoLinkToChildDataKey(PlainCryptoKey fromPlainCryptoKey, CryptreeNode toChild) {
            Objects.requireNonNull(fromPlainCryptoKey, "fromPlainCryptoKey");
            Objects.requireNonNull(toChild, "toChild");
            PlainCryptoKey childDataKeyPlainCryptoKey = toChild.getActivePlainCryptoKey(CryptoKeyRole.dataKey, CipherOperationMode.DECRYPT);
            if (childDataKeyPlainCryptoKey != null) {
                CryptreeNodeUtil.createCryptoLink(toChild, fromPlainCryptoKey, childDataKeyPlainCryptoKey);
            }
        }
    }

    static class SubdirKeyPlainCryptoKeyFactory
    extends PlainCryptoKeyFactory {
        private static final Logger logger = LoggerFactory.getLogger(SubdirKeyPlainCryptoKeyFactory.class);

        SubdirKeyPlainCryptoKeyFactory() {
        }

        @Override
        public PlainCryptoKey createPlainCryptoKey() {
            PlainCryptoKey plainCryptoKey_publicOrShared;
            PlainCryptoKey plainCryptoKey_privateOrShared;
            PermissionDao permissionDao;
            CryptreeNode cryptreeNode = this.getCryptreeNodeOrFail();
            logger.debug("createPlainCryptoKey: >>> cryptoRepoFile={} repoFile={}", (Object)cryptreeNode.getCryptoRepoFile(), (Object)cryptreeNode.getRepoFile());
            if (!cryptreeNode.isDirectory()) {
                throw new IllegalStateException("Cannot create a subdirKey, because this CryptreeNode is *not* a directory!");
            }
            CryptoRepoFile cryptoRepoFile = cryptreeNode.getCryptoRepoFile();
            CryptoKeyType cryptoKeyType = cryptoRepoFile == null ? CryptoKeyType.symmetric : (0L == (permissionDao = (PermissionDao)((Object)this.getContextOrFail().transaction.getDao(PermissionDao.class))).getPermissionCountOfDirectChildCryptoRepoFiles(cryptoRepoFile, PermissionType.grant) ? CryptoKeyType.symmetric : CryptoKeyType.asymmetric);
            switch (cryptoKeyType) {
                case symmetric: {
                    plainCryptoKey_publicOrShared = plainCryptoKey_privateOrShared = this.createSymmetricPlainCryptoKey(CryptoKeyRole.subdirKey);
                    break;
                }
                case asymmetric: {
                    AsymmetricCipherKeyPair keyPair = KeyFactory.getInstance().createAsymmetricKeyPair();
                    CryptoKey cryptoKey = this.createCryptoKey(CryptoKeyRole.subdirKey, cryptoKeyType);
                    plainCryptoKey_publicOrShared = new PlainCryptoKey(cryptoKey, CryptoKeyPart.publicKey, (CipherParameters)keyPair.getPublic());
                    plainCryptoKey_privateOrShared = new PlainCryptoKey(cryptoKey, CryptoKeyPart.privateKey, (CipherParameters)keyPair.getPrivate());
                    CryptreeNodeUtil.createCryptoLink(cryptreeNode, plainCryptoKey_publicOrShared);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected cryptoKeyType: " + cryptoKeyType);
                }
            }
            boolean saved = false;
            saved |= this.createCryptoLinkFromParentSubdirKey(plainCryptoKey_privateOrShared);
            if (!(saved |= this.createCryptoLinkFromClearanceKey(plainCryptoKey_privateOrShared))) {
                throw new IllegalStateException("Cannot create subdirKey because nobody has a clearance key leading directly or indirectly to it!");
            }
            this.createCryptoLinkToFileKey(plainCryptoKey_publicOrShared);
            PermissionSet permissionSet = cryptreeNode.getPermissionSet();
            if (permissionSet == null || this.containsNonRevokedPermissionSetInheritance(permissionSet)) {
                for (CryptreeNode child : cryptreeNode.getChildren()) {
                    this.createCryptoLinkToChildSubdirKey(plainCryptoKey_publicOrShared, child);
                    this.createCryptoLinkToChildBacklinkKey(plainCryptoKey_publicOrShared, child);
                }
            }
            logger.debug("createPlainCryptoKey: <<< cryptoRepoFile={} repoFile={}", (Object)cryptreeNode.getCryptoRepoFile(), (Object)cryptreeNode.getRepoFile());
            switch (this.getCipherOperationModeOrFail()) {
                case DECRYPT: {
                    return plainCryptoKey_privateOrShared;
                }
                case ENCRYPT: {
                    return plainCryptoKey_publicOrShared;
                }
            }
            throw new IllegalStateException("Property cipherOperationMode has an unexpected value: " + this.getCipherOperationModeOrFail());
        }

        private void createCryptoLinkToChildSubdirKey(PlainCryptoKey fromPlainCryptoKey, CryptreeNode toChild) {
            Objects.requireNonNull(fromPlainCryptoKey, "fromPlainCryptoKey");
            Objects.requireNonNull(toChild, "toChild");
            if (!toChild.isDirectory()) {
                return;
            }
            PlainCryptoKey childSubdirKeyPlainCryptoKey = toChild.getActivePlainCryptoKey(CryptoKeyRole.subdirKey, CipherOperationMode.DECRYPT);
            if (childSubdirKeyPlainCryptoKey != null) {
                CryptreeNodeUtil.createCryptoLink(toChild, fromPlainCryptoKey, childSubdirKeyPlainCryptoKey);
            }
        }

        private void createCryptoLinkToFileKey(PlainCryptoKey fromPlainCryptoKey) {
            Objects.requireNonNull(fromPlainCryptoKey, "fromPlainCryptoKey");
            CryptreeNode cryptreeNode = this.getCryptreeNodeOrFail();
            PlainCryptoKey fileKeyPlainCryptoKey = cryptreeNode.getActivePlainCryptoKey(CryptoKeyRole.fileKey, CipherOperationMode.DECRYPT);
            if (fileKeyPlainCryptoKey != null) {
                CryptreeNodeUtil.createCryptoLink(cryptreeNode, fromPlainCryptoKey, fileKeyPlainCryptoKey);
            }
        }

        private void createCryptoLinkToChildBacklinkKey(PlainCryptoKey fromPlainCryptoKey, CryptreeNode toChild) {
            Objects.requireNonNull(fromPlainCryptoKey, "fromPlainCryptoKey");
            Objects.requireNonNull(toChild, "toChild");
            if (toChild.isDirectory()) {
                return;
            }
            PlainCryptoKey childBacklinkKeyPlainCryptoKey = toChild.getActivePlainCryptoKey(CryptoKeyRole.backlinkKey, CipherOperationMode.DECRYPT);
            if (childBacklinkKeyPlainCryptoKey != null) {
                CryptreeNodeUtil.createCryptoLink(toChild, fromPlainCryptoKey, childBacklinkKeyPlainCryptoKey);
            }
        }

        private boolean createCryptoLinkFromParentSubdirKey(PlainCryptoKey toPlainCryptoKey) {
            PermissionSet parentPermissionSet;
            Objects.requireNonNull(toPlainCryptoKey, "toPlainCryptoKey");
            CryptreeNode cryptreeNode = this.getCryptreeNodeOrFail();
            CryptreeNode parent = cryptreeNode.getParent();
            if (parent != null && ((parentPermissionSet = cryptreeNode.getPermissionSet()) == null || this.containsNonRevokedPermissionSetInheritance(parentPermissionSet))) {
                PlainCryptoKey subdirKeyPlainCryptoKey = parent.getActivePlainCryptoKeyOrCreate(CryptoKeyRole.subdirKey, CipherOperationMode.ENCRYPT);
                CryptreeNodeUtil.createCryptoLink(cryptreeNode, subdirKeyPlainCryptoKey, toPlainCryptoKey);
                return true;
            }
            return false;
        }

        private boolean containsNonRevokedPermissionSetInheritance(PermissionSet permissionSet) {
            Objects.requireNonNull(permissionSet, "permissionSet");
            for (PermissionSetInheritance permissionSetInheritance : permissionSet.getPermissionSetInheritances()) {
                if (permissionSetInheritance.getRevoked() != null) continue;
                return true;
            }
            return false;
        }

        private boolean createCryptoLinkFromClearanceKey(PlainCryptoKey toPlainCryptoKey) {
            Objects.requireNonNull(toPlainCryptoKey, "toPlainCryptoKey");
            CryptreeNode cryptreeNode = this.getCryptreeNodeOrFail();
            PlainCryptoKey clearanceKeyPlainCryptoKey_public = cryptreeNode.getParent() == null ? cryptreeNode.getActivePlainCryptoKeyOrCreate(CryptoKeyRole.clearanceKey, CipherOperationMode.ENCRYPT) : cryptreeNode.getActivePlainCryptoKey(CryptoKeyRole.clearanceKey, CipherOperationMode.ENCRYPT);
            if (clearanceKeyPlainCryptoKey_public != null) {
                CryptreeNodeUtil.createCryptoLink(cryptreeNode, clearanceKeyPlainCryptoKey_public, toPlainCryptoKey);
                return true;
            }
            return false;
        }
    }

    static class ClearanceKeyPlainCryptoKeyFactory
    extends PlainCryptoKeyFactory {
        private static final Logger logger = LoggerFactory.getLogger(ClearanceKeyPlainCryptoKeyFactory.class);

        ClearanceKeyPlainCryptoKeyFactory() {
        }

        @Override
        public PlainCryptoKey createPlainCryptoKey() {
            CryptreeNode cryptreeNode = this.getCryptreeNodeOrFail();
            CipherOperationMode cipherOperationMode = this.getCipherOperationModeOrFail();
            CryptreeContext context = this.getContextOrFail();
            logger.debug("createPlainCryptoKey: >>> cryptoRepoFile={} repoFile={}", (Object)cryptreeNode.getCryptoRepoFile(), (Object)cryptreeNode.getRepoFile());
            AsymmetricCipherKeyPair keyPair = KeyFactory.getInstance().createAsymmetricKeyPair();
            CryptoKey cryptoKey = this.createCryptoKey(CryptoKeyRole.clearanceKey, CryptoKeyType.asymmetric);
            PlainCryptoKey clearanceKeyPlainCryptoKey_public = new PlainCryptoKey(cryptoKey, CryptoKeyPart.publicKey, (CipherParameters)keyPair.getPublic());
            PlainCryptoKey clearanceKeyPlainCryptoKey_private = new PlainCryptoKey(cryptoKey, CryptoKeyPart.privateKey, (CipherParameters)keyPair.getPrivate());
            CryptreeNodeUtil.createCryptoLink(this.getCryptreeNodeOrFail(), clearanceKeyPlainCryptoKey_public);
            UserRepoKey userRepoKeyForRead = cryptreeNode.getUserRepoKey(false, PermissionType.write);
            if (userRepoKeyForRead == null) {
                userRepoKeyForRead = (UserRepoKey)context.userRepoKeyRing.getPermanentUserRepoKeys(context.serverRepositoryId).get(0);
            }
            UserRepoKeyPublicKey userRepoKeyPublicKey = cryptreeNode.getUserRepoKeyPublicKeyOrCreate(userRepoKeyForRead);
            CryptreeNodeUtil.createCryptoLink(this.getCryptreeNodeOrFail(), userRepoKeyPublicKey, clearanceKeyPlainCryptoKey_private);
            this.createCryptoLinkToSubdirKey(clearanceKeyPlainCryptoKey_public);
            logger.debug("createPlainCryptoKey: <<< cryptoRepoFile={} repoFile={}", (Object)cryptreeNode.getCryptoRepoFile(), (Object)cryptreeNode.getRepoFile());
            switch (cipherOperationMode) {
                case DECRYPT: {
                    return clearanceKeyPlainCryptoKey_private;
                }
                case ENCRYPT: {
                    return clearanceKeyPlainCryptoKey_public;
                }
            }
            throw new IllegalStateException("Property cipherOperationMode has an unexpected value: " + cipherOperationMode);
        }

        private void createCryptoLinkToSubdirKey(PlainCryptoKey fromPlainCryptoKey) {
            Objects.requireNonNull(fromPlainCryptoKey, "fromPlainCryptoKey");
            CryptreeNode cryptreeNode = this.getCryptreeNodeOrFail();
            PlainCryptoKey subdirKeyPlainCryptoKey = cryptreeNode.getActivePlainCryptoKey(CryptoKeyRole.subdirKey, CipherOperationMode.DECRYPT);
            if (subdirKeyPlainCryptoKey != null) {
                CryptreeNodeUtil.createCryptoLink(this.getCryptreeNodeOrFail(), fromPlainCryptoKey, subdirKeyPlainCryptoKey);
            }
        }
    }
}

