/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.local.persistence.Dao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subshare.core.dto.PermissionType;
import org.subshare.local.persistence.CryptoRepoFile;
import org.subshare.local.persistence.Permission;
import org.subshare.local.persistence.PermissionSet;
import org.subshare.local.persistence.UserRepoKeyPublicKey;

public class PermissionDao
extends Dao<Permission, PermissionDao> {
    private static final Logger logger = LoggerFactory.getLogger(PermissionDao.class);

    public Collection<Permission> getNonRevokedPermissions(PermissionType permissionType, Set<Uid> userRepoKeyIds) {
        Objects.requireNonNull(permissionType, "permissionType");
        Objects.requireNonNull(userRepoKeyIds, "userRepoKeyIds");
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (Uid userRepoKeyId : userRepoKeyIds) {
            Collection<Permission> c = this.getNonRevokedPermissions(permissionType, userRepoKeyId);
            permissions.addAll(c);
        }
        return permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Permission> getNonRevokedPermissions(PermissionType permissionType, Uid userRepoKeyId) {
        Objects.requireNonNull(permissionType, "permissionType");
        Objects.requireNonNull(userRepoKeyId, "userRepoKeyId");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getNonRevokedPermissions_permissionType_userRepoKeyId");
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("permissionType", permissionType);
            params.put("userRepoKeyId", userRepoKeyId.toString());
            long startTimestamp = System.currentTimeMillis();
            Collection permissions = (Collection)query.executeWithMap(params);
            logger.debug("getNonRevokedPermissions: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            permissions = this.load(permissions);
            logger.debug("getNonRevokedPermissions: Loading result-set with {} elements took {} ms.", (Object)permissions.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = permissions;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Permission> getNonRevokedPermissions(PermissionType permissionType) {
        Objects.requireNonNull(permissionType, "permissionType");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getNonRevokedPermissions_permissionType");
        try {
            HashMap<String, PermissionType> params = new HashMap<String, PermissionType>(1);
            params.put("permissionType", permissionType);
            long startTimestamp = System.currentTimeMillis();
            Collection permissions = (Collection)query.executeWithMap(params);
            logger.debug("getNonRevokedPermissions: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            permissions = this.load(permissions);
            logger.debug("getNonRevokedPermissions: Loading result-set with {} elements took {} ms.", (Object)permissions.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = permissions;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    public Collection<Permission> getNonRevokedPermissions(PermissionSet permissionSet, PermissionType permissionType, UserRepoKeyPublicKey userRepoKeyPublicKey) {
        Objects.requireNonNull(permissionSet, "permissionSet");
        Objects.requireNonNull(permissionType, "permissionType");
        Objects.requireNonNull(userRepoKeyPublicKey, "userRepoKeyPublicKey");
        return this.getNonRevokedPermissions(permissionSet, permissionType, userRepoKeyPublicKey.getUserRepoKeyId());
    }

    public Collection<Permission> getNonRevokedPermissions(PermissionSet permissionSet, PermissionType permissionType, Set<Uid> userRepoKeyIds) {
        Objects.requireNonNull(permissionSet, "permissionSet");
        Objects.requireNonNull(permissionType, "permissionType");
        Objects.requireNonNull(userRepoKeyIds, "userRepoKeyIds");
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (Uid userRepoKeyId : userRepoKeyIds) {
            Collection<Permission> c = this.getNonRevokedPermissions(permissionSet, permissionType, userRepoKeyId);
            permissions.addAll(c);
        }
        return permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Permission> getNonRevokedPermissions(PermissionSet permissionSet, PermissionType permissionType, Uid userRepoKeyId) {
        Objects.requireNonNull(permissionSet, "permissionSet");
        Objects.requireNonNull(permissionType, "permissionType");
        Objects.requireNonNull(userRepoKeyId, "userRepoKeyId");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getNonRevokedPermissions_permissionSet_permissionType_userRepoKeyId");
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(3);
            params.put("permissionSet", (Object)permissionSet);
            params.put("permissionType", permissionType);
            params.put("userRepoKeyId", userRepoKeyId.toString());
            long startTimestamp = System.currentTimeMillis();
            Collection permissions = (Collection)query.executeWithMap(params);
            logger.debug("getNonRevokedPermissions: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            permissions = this.load(permissions);
            logger.debug("getNonRevokedPermissions: Loading result-set with {} elements took {} ms.", (Object)permissions.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = permissions;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Permission> getValidPermissions(PermissionType permissionType, Uid userRepoKeyId, Date timestamp) {
        Objects.requireNonNull(permissionType, "permissionType");
        Objects.requireNonNull(userRepoKeyId, "userRepoKeyId");
        Objects.requireNonNull(timestamp, "timestamp");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getValidPermissions_permissionType_userRepoKeyId_timestamp");
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(3);
            params.put("permissionType", permissionType);
            params.put("userRepoKeyId", userRepoKeyId.toString());
            params.put("timestamp", timestamp);
            long startTimestamp = System.currentTimeMillis();
            Collection permissions = (Collection)query.executeWithMap(params);
            logger.debug("getValidPermissions: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            permissions = this.load(permissions);
            logger.debug("getValidPermissions: Loading result-set with {} elements took {} ms.", (Object)permissions.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = permissions;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Permission> getValidPermissions(PermissionSet permissionSet, PermissionType permissionType, Uid userRepoKeyId, Date timestamp) {
        Objects.requireNonNull(permissionSet, "permissionSet");
        Objects.requireNonNull(permissionType, "permissionType");
        Objects.requireNonNull(userRepoKeyId, "userRepoKeyId");
        Objects.requireNonNull(timestamp, "timestamp");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getValidPermissions_permissionSet_permissionType_userRepoKeyId_timestamp");
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(3);
            params.put("permissionSet", (Object)permissionSet);
            params.put("permissionType", permissionType);
            params.put("userRepoKeyId", userRepoKeyId.toString());
            params.put("timestamp", timestamp);
            long startTimestamp = System.currentTimeMillis();
            Collection permissions = (Collection)query.executeWithMap(params);
            logger.debug("getValidPermissions: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            permissions = this.load(permissions);
            logger.debug("getValidPermissions: Loading result-set with {} elements took {} ms.", (Object)permissions.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = permissions;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Permission> getPermissions(UserRepoKeyPublicKey userRepoKeyPublicKey) {
        Objects.requireNonNull(userRepoKeyPublicKey, "userRepoKeyPublicKey");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getPermissions_userRepoKeyPublicKey");
        try {
            HashMap<String, UserRepoKeyPublicKey> params = new HashMap<String, UserRepoKeyPublicKey>(3);
            params.put("userRepoKeyPublicKey", userRepoKeyPublicKey);
            long startTimestamp = System.currentTimeMillis();
            Collection permissions = (Collection)query.executeWithMap(params);
            logger.debug("getPermissions: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            permissions = this.load(permissions);
            logger.debug("getPermissions: Loading result-set with {} elements took {} ms.", (Object)permissions.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = permissions;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPermissionCountOfDirectChildCryptoRepoFiles(CryptoRepoFile parentCryptoRepoFile, PermissionType permissionType) {
        Objects.requireNonNull(parentCryptoRepoFile, "parentCryptoRepoFile");
        Objects.requireNonNull(permissionType, "permissionType");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "PermissionCountOfDirectChildCryptoRepoFiles_parentCryptoRepoFile_permissionType");
        try {
            Long count = (Long)query.execute((Object)parentCryptoRepoFile, (Object)permissionType);
            long l = count;
            return l;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Permission> getPermissionsChangedAfter(long localRevision) {
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getPermissionsChangedAfter_localRevision");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection permissions = (Collection)query.execute((Object)localRevision);
            logger.debug("getPermissionsChangedAfter: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            permissions = this.load(permissions);
            logger.debug("getPermissionsChangedAfter: Loading result-set with {} elements took {} ms.", (Object)permissions.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = permissions;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permission getPermission(Uid permissionId) {
        Objects.requireNonNull(permissionId, "permissionId");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getPermission_permissionId");
        try {
            Permission permission;
            Permission permission2 = permission = (Permission)((Object)query.execute((Object)permissionId.toString()));
            return permission2;
        }
        finally {
            query.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Permission> getPermissionsSignedBy(Uid signingUserRepoKeyId) {
        Objects.requireNonNull(signingUserRepoKeyId, "signingUserRepoKeyId");
        Query query = this.pm().newNamedQuery(this.getEntityClass(), "getPermissions_signingUserRepoKeyId");
        try {
            long startTimestamp = System.currentTimeMillis();
            Collection permissions = (Collection)query.execute((Object)signingUserRepoKeyId.toString());
            logger.debug("getPermissionsSignedBy: query.execute(...) took {} ms.", (Object)(System.currentTimeMillis() - startTimestamp));
            startTimestamp = System.currentTimeMillis();
            permissions = this.load(permissions);
            logger.debug("getPermissionsSignedBy: Loading result-set with {} elements took {} ms.", (Object)permissions.size(), (Object)(System.currentTimeMillis() - startTimestamp));
            Collection collection = permissions;
            return collection;
        }
        finally {
            query.closeAll();
        }
    }
}

