/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.local.persistence;

import co.codewizards.cloudstore.core.Uid;
import co.codewizards.cloudstore.local.persistence.Dao;
import co.codewizards.cloudstore.local.persistence.Entity;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import javax.jdo.Query;
import org.subshare.core.sign.Signable;

public class SignableDao
extends Dao<Entity, SignableDao> {
    public boolean isEntitiesSignedByAndAfter(Uid signingUserRepoKeyId, Date signatureCreatedAfter) {
        Objects.requireNonNull(signingUserRepoKeyId, "signingUserRepoKeyId");
        Objects.requireNonNull(signatureCreatedAfter, "signatureCreatedAfter");
        Collection entityClasses = this.pm().getPersistenceManagerFactory().getManagedClasses();
        for (Class entityClass : entityClasses) {
            Class signableEntityClass;
            long count;
            if (!Signable.class.isAssignableFrom(entityClass) || (count = this.getEntitiesCountSignedByAndAfter(signableEntityClass = entityClass, signingUserRepoKeyId, signatureCreatedAfter)) <= 0L) continue;
            return true;
        }
        return false;
    }

    private long getEntitiesCountSignedByAndAfter(Class<? extends Signable> signableEntityClass, Uid signingUserRepoKeyId, Date signatureCreatedAfter) {
        Query q = this.pm().newQuery(signableEntityClass);
        q.setResult("count(this)");
        q.setFilter("this.signature.signingUserRepoKeyId == :signingUserRepoKeyId && this.signature.signatureCreated > :signatureCreatedAfter");
        Long result = (Long)q.execute((Object)signingUserRepoKeyId.toString(), (Object)signatureCreatedAfter);
        return result;
    }
}

