/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.wot;

import org.bouncycastle.openpgp.wot.TrustConst;

public class Config
implements TrustConst {
    public static final int TM_CLASSIC = 0;
    public static final int TM_PGP = 1;
    public static final int TM_EXTERNAL = 2;
    public static final int TM_ALWAYS = 3;
    public static final int TM_DIRECT = 4;
    private static final Config instance = new Config();

    protected Config() {
    }

    public static Config getInstance() {
        return instance;
    }

    public short getMarginalsNeeded() {
        return 3;
    }

    public short getCompletesNeeded() {
        return 1;
    }

    public short getMaxCertDepth() {
        return 5;
    }

    public short getTrustModel() {
        return 1;
    }

    public short getMinCertLevel() {
        return 2;
    }

    public String getTrustModelAsString() {
        switch (this.getTrustModel()) {
            case 0: {
                return "classic";
            }
            case 1: {
                return "PGP";
            }
            case 2: {
                return "external";
            }
            case 3: {
                return "always";
            }
            case 4: {
                return "direct";
            }
        }
        return "unknown[" + this.getTrustModel() + "]";
    }
}

