/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.io;

import co.codewizards.cloudstore.core.io.ByteArrayInputStream;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.StreamUtil;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class LimitedInputStream
extends FilterInputStream
implements IInputStream {
    private final int minLimit;
    private final int maxLimit;
    private int readPos = 0;

    public LimitedInputStream(IInputStream in, int minLimit, int maxLimit) {
        this(StreamUtil.castStream((IInputStream)in), minLimit, maxLimit);
    }

    public LimitedInputStream(InputStream in, int minLimit, int maxLimit) {
        super(Objects.requireNonNull(in, "in"));
        this.minLimit = minLimit;
        this.maxLimit = maxLimit;
    }

    public LimitedInputStream(ByteArrayInputStream in, int minLimit, int maxLimit) {
        this((InputStream)in, minLimit, maxLimit);
    }

    @Override
    public int available() throws IOException {
        int reallyAvailable = this.in.available();
        if (reallyAvailable < 0 && this.readPos < this.minLimit) {
            throw new IOException("inputStream is closed; only " + this.readPos + " Bytes read, but minLimit = " + this.minLimit + " Bytes!");
        }
        if (reallyAvailable <= 0) {
            return reallyAvailable;
        }
        int limitedAvailable = Math.min(reallyAvailable, this.maxLimit - this.readPos);
        if (limitedAvailable <= 0) {
            limitedAvailable = -1;
        }
        return limitedAvailable;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public int read() throws IOException {
        if (this.readPos < this.maxLimit) {
            int res = this.in.read();
            if (res >= 0) {
                ++this.readPos;
            } else if (this.readPos < this.minLimit) {
                throw new IOException("inputStream is closed; only " + this.readPos + " Bytes read, but minLimit = " + this.minLimit + " Bytes!");
            }
            return res;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.readPos + len > this.maxLimit && (len = this.maxLimit - this.readPos) == 0) {
            return -1;
        }
        if (len > 0) {
            int bytesRead = this.in.read(b, off, len);
            if (bytesRead > 0) {
                this.readPos += bytesRead;
            }
            if (bytesRead < 0 && this.readPos < this.minLimit) {
                throw new IOException("inputStream is closed; only " + this.readPos + " Bytes read, but minLimit = " + this.minLimit + " Bytes!");
            }
            return bytesRead;
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len < 0!");
        }
        return 0;
    }

    @Override
    public long skip(long len) throws IOException {
        if ((long)this.readPos + len > (long)this.maxLimit) {
            len = this.maxLimit - this.readPos;
        }
        if (len > 0L) {
            long bytesSkipped = this.in.skip(len);
            if (bytesSkipped > 0L) {
                this.readPos = (int)((long)this.readPos + bytesSkipped);
            }
            return bytesSkipped;
        }
        return 0L;
    }

    @Override
    public void close() throws IOException {
    }
}

