/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.locker;

import co.codewizards.cloudstore.core.io.ByteArrayOutputStream;
import co.codewizards.cloudstore.core.io.IInputStream;
import co.codewizards.cloudstore.core.io.LockFile;
import co.codewizards.cloudstore.core.io.LockFileFactory;
import co.codewizards.cloudstore.core.io.StreamUtil;
import co.codewizards.cloudstore.core.oio.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.util.io.Streams;
import org.subshare.core.locker.LockerContent;

public abstract class FileLockerContent
implements LockerContent {
    @Override
    public String getName() {
        return this.getFileOrFail().getName();
    }

    protected abstract File getFile();

    protected File getFileOrFail() {
        File file = this.getFile();
        if (file == null) {
            throw new IllegalStateException(String.format("Implementation error in %s: getFile() returned null!", this.getClass().getName()));
        }
        return file;
    }

    @Override
    public byte[] getLocalData() throws IOException {
        File file = this.getFileOrFail();
        try (LockFile lockFile = this.acquireLockFile();){
            byte[] byArray = this.getData(file, lockFile);
            return byArray;
        }
    }

    protected LockFile acquireLockFile() {
        File file = this.getFileOrFail();
        LockFile lockFile = LockFileFactory.getInstance().acquire(file, 30000L);
        return lockFile;
    }

    protected byte[] getData(File file, LockFile lockFile) throws IOException {
        try (InputStream in = StreamUtil.castStream((IInputStream)lockFile.createInputStream());){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Streams.pipeAll((InputStream)in, (OutputStream)out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }
}

