/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.core.pgp;

import co.codewizards.cloudstore.core.util.HashUtil;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.subshare.core.dto.jaxb.PgpKeyFingerprintXmlAdapter;

@XmlJavaTypeAdapter(value=PgpKeyFingerprintXmlAdapter.class)
public class PgpKeyFingerprint
implements Comparable<PgpKeyFingerprint>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] fingerprint;
    private volatile transient int hashCode;
    private volatile transient WeakReference<String> toString;
    private volatile transient WeakReference<String> toHumanString;

    public PgpKeyFingerprint(byte[] fingerprint) {
        Objects.requireNonNull(fingerprint, "fingerprint");
        this.fingerprint = Arrays.copyOf(fingerprint, fingerprint.length);
    }

    public PgpKeyFingerprint(String fingerprint) {
        Objects.requireNonNull(fingerprint, "fingerprint");
        this.fingerprint = HashUtil.decodeHexStr((String)fingerprint);
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.fingerprint, this.fingerprint.length);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.fingerprint);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PgpKeyFingerprint other = (PgpKeyFingerprint)obj;
        return Arrays.equals(this.fingerprint, other.fingerprint);
    }

    @Override
    public int compareTo(PgpKeyFingerprint o) {
        int res = Integer.compare(this.fingerprint.length, o.fingerprint.length);
        if (res != 0) {
            return res;
        }
        for (int i = 0; i < this.fingerprint.length; ++i) {
            res = Byte.compare(this.fingerprint[i], o.fingerprint[i]);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public String toString() {
        String s;
        String string = s = this.toString == null ? null : (String)this.toString.get();
        if (s == null) {
            s = HashUtil.encodeHexStr((byte[])this.fingerprint).toUpperCase(Locale.GERMAN);
            this.toString = new WeakReference<String>(s);
        }
        return s;
    }

    public String toHumanString() {
        String s;
        String string = s = this.toHumanString == null ? null : (String)this.toHumanString.get();
        if (s == null) {
            s = this._toHumanString();
            this.toHumanString = new WeakReference<String>(s);
        }
        return s;
    }

    private String _toHumanString() {
        StringBuilder sb = new StringBuilder();
        String string = this.toString();
        for (int i = 0; i < string.length(); ++i) {
            if (i > 0 && i % 4 == 0) {
                sb.append(' ');
            }
            sb.append(string.charAt(i));
        }
        return sb.toString();
    }
}

