/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.io.CipherOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;

public class BcPGPDataEncryptorBuilder
implements PGPDataEncryptorBuilder {
    private SecureRandom random;
    private boolean withIntegrityPacket;
    private int encAlgorithm;

    public BcPGPDataEncryptorBuilder(int encAlgorithm) {
        this.encAlgorithm = encAlgorithm;
        if (encAlgorithm == 0) {
            throw new IllegalArgumentException("null cipher specified");
        }
    }

    public BcPGPDataEncryptorBuilder setWithIntegrityPacket(boolean withIntegrityPacket) {
        this.withIntegrityPacket = withIntegrityPacket;
        return this;
    }

    public BcPGPDataEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public int getAlgorithm() {
        return this.encAlgorithm;
    }

    public SecureRandom getSecureRandom() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return this.random;
    }

    public PGPDataEncryptor build(byte[] keyBytes) throws PGPException {
        return new MyPGPDataEncryptor(keyBytes);
    }

    private class MyPGPDataEncryptor
    implements PGPDataEncryptor {
        private final BufferedBlockCipher c;

        MyPGPDataEncryptor(byte[] keyBytes) throws PGPException {
            BlockCipher engine = BcImplProvider.createBlockCipher(BcPGPDataEncryptorBuilder.this.encAlgorithm);
            try {
                this.c = BcUtil.createStreamCipher(true, engine, BcPGPDataEncryptorBuilder.this.withIntegrityPacket, keyBytes);
            }
            catch (IllegalArgumentException e) {
                throw new PGPException("invalid parameters: " + e.getMessage(), e);
            }
        }

        public OutputStream getOutputStream(OutputStream out) {
            return new CipherOutputStream(out, this.c);
        }

        public PGPDigestCalculator getIntegrityCalculator() {
            if (BcPGPDataEncryptorBuilder.this.withIntegrityPacket) {
                return new SHA1PGPDigestCalculator();
            }
            return null;
        }

        public int getBlockSize() {
            return this.c.getBlockSize();
        }
    }
}

