/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.rest.server.service;

import co.codewizards.cloudstore.core.config.ConfigImpl;
import co.codewizards.cloudstore.core.oio.File;
import co.codewizards.cloudstore.core.oio.OioFileFactory;
import co.codewizards.cloudstore.core.repo.local.CreateRepositoryContext;
import co.codewizards.cloudstore.core.repo.local.LocalRepoHelper;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManagerFactory;
import co.codewizards.cloudstore.core.util.IOUtil;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.subshare.core.dto.CreateRepositoryRequestDto;
import org.subshare.core.pgp.PgpSignature;
import org.subshare.core.sign.PgpSignable;
import org.subshare.core.sign.PgpSignableVerifier;

@Path(value="_createRepository")
@Consumes(value={"application/xml"})
@Produces(value={"application/xml"})
public class CreateRepositoryService {
    public static final String CONFIG_KEY_REPO_BASE_DIR = "repoBaseDir";
    public static final String DEFAULT_REPO_BASE_DIR = "${user.home}/subshare-repo.d";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    public void createRepository(CreateRepositoryRequestDto createRepositoryRequestDto) {
        Objects.requireNonNull(createRepositoryRequestDto, "createRepositoryRequestDto");
        UUID serverRepositoryId = Objects.requireNonNull(createRepositoryRequestDto.getServerRepositoryId(), "createRepositoryRequestDto.serverRepositoryId");
        PgpSignature pgpSignature = new PgpSignableVerifier().verify((PgpSignable)createRepositoryRequestDto);
        String baseDir = ConfigImpl.getInstance().getPropertyAsNonEmptyTrimmedString(CONFIG_KEY_REPO_BASE_DIR, DEFAULT_REPO_BASE_DIR);
        String resolvedBaseDir = IOUtil.replaceTemplateVariables((String)baseDir, (Map)System.getProperties());
        File localDirectory = OioFileFactory.createFile((String)resolvedBaseDir, (String[])new String[]{serverRepositoryId.toString()}).getAbsoluteFile();
        localDirectory.mkdirs();
        File localRoot = LocalRepoHelper.getLocalRootContainingFile((File)localDirectory);
        if (localRoot == null) {
            CreateRepositoryContext.repositoryIdThreadLocal.set(serverRepositoryId);
            try {
                LocalRepoManager localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForNewRepository(localDirectory);
                Throwable throwable = null;
                if (localRepoManager == null) return;
                if (throwable != null) {
                    try {
                        localRepoManager.close();
                        return;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    return;
                }
                localRepoManager.close();
                return;
            }
            finally {
                CreateRepositoryContext.repositoryIdThreadLocal.remove();
            }
        } else {
            if (!localRoot.equals(localDirectory)) {
                throw new IllegalStateException(String.format("WTF?! The path '%s' which is configured for the key '%s' seems to be inside another repository!", baseDir, CONFIG_KEY_REPO_BASE_DIR));
            }
            LocalRepoManager localRepoManager = LocalRepoManagerFactory.Helper.getInstance().createLocalRepoManagerForExistingRepository(localRoot);
            Throwable throwable = null;
            if (localRepoManager == null) return;
            if (throwable != null) {
                try {
                    localRepoManager.close();
                    return;
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                return;
            } else {
                localRepoManager.close();
            }
        }
    }
}

