/*
 * Decompiled with CFR 0.152.
 */
package org.subshare.rest.server.service;

import co.codewizards.cloudstore.core.dto.RepositoryDto;
import co.codewizards.cloudstore.core.repo.local.ContextWithLocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoManager;
import co.codewizards.cloudstore.core.repo.local.LocalRepoTransaction;
import co.codewizards.cloudstore.core.repo.transport.RepoTransport;
import co.codewizards.cloudstore.rest.server.service.RequestRepoConnectionService;
import java.util.Objects;
import java.util.UUID;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.subshare.core.Cryptree;
import org.subshare.core.CryptreeFactory;
import org.subshare.core.CryptreeFactoryRegistry;
import org.subshare.core.dto.SsRequestRepoConnectionRepositoryDto;
import org.subshare.core.sign.Signable;
import org.subshare.core.sign.SignableVerifier;

@Path(value="_requestRepoConnection/{repositoryName}")
public class SsRequestRepoConnectionService
extends RequestRepoConnectionService {
    protected void requestConnection(RepoTransport repoTransport, String pathPrefix, RepositoryDto clientRepositoryDto) {
        this.verifyRepositoryDto(repoTransport, clientRepositoryDto);
        super.requestConnection(repoTransport, pathPrefix, clientRepositoryDto);
        this.acceptConnection(repoTransport, pathPrefix, clientRepositoryDto);
    }

    private void verifyRepositoryDto(RepoTransport repoTransport, RepositoryDto clientRepositoryDto) {
        Objects.requireNonNull(repoTransport, "repoTransport");
        Objects.requireNonNull(clientRepositoryDto, "clientRepositoryDto");
        UUID clientRepositoryId = Objects.requireNonNull(repoTransport.getClientRepositoryId(), "repoTransport.clientRepositoryId");
        if (!clientRepositoryId.equals(clientRepositoryDto.getRepositoryId())) {
            throw new IllegalArgumentException("repoTransport.clientRepositoryId != clientRepositoryDto.clientRepositoryId");
        }
        if (!(clientRepositoryDto instanceof SsRequestRepoConnectionRepositoryDto)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)"clientRepositoryDto is not an instance of SsRequestRepoConnectionRepositoryDto!").build());
        }
        LocalRepoManager localRepoManager = ((ContextWithLocalRepoManager)repoTransport).getLocalRepoManager();
        try (LocalRepoTransaction transaction = localRepoManager.beginReadTransaction();){
            SsRequestRepoConnectionRepositoryDto rrcRepositoryDto = (SsRequestRepoConnectionRepositoryDto)clientRepositoryDto;
            CryptreeFactory cryptreeFactory = CryptreeFactoryRegistry.getInstance().getCryptreeFactoryOrFail();
            Cryptree cryptree = cryptreeFactory.getCryptreeOrCreate(transaction, clientRepositoryId);
            if (!cryptree.isEmpty()) {
                SignableVerifier signableVerifier = new SignableVerifier(cryptree.getUserRepoKeyPublicKeyLookup());
                signableVerifier.verify((Signable)rrcRepositoryDto);
            }
        }
    }

    private void acceptConnection(RepoTransport repoTransport, String pathPrefix, RepositoryDto clientRepositoryDto) {
        Objects.requireNonNull(repoTransport, "repoTransport");
        Objects.requireNonNull(clientRepositoryDto, "clientRepositoryDto");
        UUID clientRepositoryId = Objects.requireNonNull(repoTransport.getClientRepositoryId(), "clientRepositoryId");
        LocalRepoManager localRepoManager = ((ContextWithLocalRepoManager)repoTransport).getLocalRepoManager();
        byte[] remotePublicKey = clientRepositoryDto.getPublicKey();
        String localPathPrefix = pathPrefix;
        localRepoManager.putRemoteRepository(clientRepositoryId, null, remotePublicKey, localPathPrefix);
    }
}

